/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ReplaceJoinOverConstantWithProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestReplaceJoinOverConstantWithProject
extends BaseRuleTest {
    public TestReplaceJoinOverConstantWithProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnJoinWithEmptySource() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.values(0, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(1, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnJoinWithCondition() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause(p.symbol("a"), p.symbol("b")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.values(5, p.symbol("b")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new SymbolReference("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnValuesWithMultipleRows() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(5, p.symbol("a")), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnValuesWithNoOutputs() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(1, new Symbol[0]), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnValuesWithNonRowExpression() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (List<Expression>)ImmutableList.of((Object)new Cast((Expression)new Row((List)ImmutableList.of((Object)new StringLiteral("true"))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"b", (Type)BooleanType.BOOLEAN)})))), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testDoesNotFireOnOuterJoinWhenSourcePossiblyEmpty() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(5L)), (PlanNode)p.values(10, p.symbol("b"))), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(5L)), (PlanNode)p.values(10, p.symbol("a"))), (PlanNode)p.values(1, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(1, p.symbol("a")), (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(5L)), (PlanNode)p.values(10, p.symbol("b"))), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.FULL, (PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(5L)), (PlanNode)p.values(10, p.symbol("a"))), (PlanNode)p.values(1, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testReplaceInnerJoinWithProject() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("x"))))), (PlanNode)p.values(5, p.symbol("c")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L)), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("x")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(5, p.symbol("c")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("x"))))), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L)), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("x")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")));
    }

    @Test
    public void testReplaceLeftJoinWithProject() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.LEFT, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("x"))))), (PlanNode)p.values(5, p.symbol("c")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L)), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("x")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(5, p.symbol("c")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("x"))))), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L)), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("x")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")));
    }

    @Test
    public void testReplaceRightJoinWithProject() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("x"))))), (PlanNode)p.values(5, p.symbol("c")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L)), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("x")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(5, p.symbol("c")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("x"))))), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L)), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("x")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")));
    }

    @Test
    public void testReplaceFullJoinWithProject() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.FULL, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("x"))))), (PlanNode)p.values(5, p.symbol("c")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L)), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("x")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")));
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(5, p.symbol("c")), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("x"))))), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L)), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("x")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")));
    }

    @Test
    public void testRemoveOutputDuplicates() {
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new LongLiteral(1L), (Object)new StringLiteral("x"))))), (PlanNode)p.values(5, p.symbol("c")), (List<JoinNode.EquiJoinClause>)ImmutableList.of(), (List<Symbol>)ImmutableList.of((Object)p.symbol("a"), (Object)p.symbol("b"), (Object)p.symbol("a"), (Object)p.symbol("b")), (List<Symbol>)ImmutableList.of((Object)p.symbol("c"), (Object)p.symbol("c")), Optional.empty())).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L)), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new StringLiteral("x")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("c"))), PlanMatchPattern.values("c")));
    }

    @Test
    public void testNonDeterministicValues() {
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("rand")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)randomFunction)))), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        FunctionCall uuidFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("uuid", (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new ReplaceJoinOverConstantWithProject(this.tester().getMetadata())).on(p -> p.join(JoinType.INNER, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("uuid")), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)uuidFunction)))), (PlanNode)p.values(5, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }
}

