/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.DecimalLiteral;
import io.trino.sql.ir.DoubleLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.ExpressionRewriter;
import io.trino.sql.ir.ExpressionTreeRewriter;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.iterative.rule.SimplifyExpressions;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimplifyExpressions {
    @Test
    public void testPushesDownNegations() {
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new SymbolReference("X")), (Expression)new NotExpression((Expression)new SymbolReference("X")), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference("X"))), (Expression)new SymbolReference("X"), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference("X")))), (Expression)new NotExpression((Expression)new SymbolReference("X")), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference("X")))), (Expression)new NotExpression((Expression)new SymbolReference("X")), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y")), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("X"), (Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference("Y"))))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y")), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("X"), (Expression)new NotExpression((Expression)new NotExpression((Expression)new SymbolReference("Y")))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y")), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"), (Object)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("Z"), (Object)new SymbolReference("V"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference("X")), (Object)new NotExpression((Expression)new SymbolReference("Y")), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("Z"), (Object)new SymbolReference("V"))))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"), (Object)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("Z"), (Object)new SymbolReference("V"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference("X")), (Object)new NotExpression((Expression)new SymbolReference("Y")), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("Z"), (Object)new SymbolReference("V"))))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("Z"), (Object)new SymbolReference("V")))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference("X")), (Object)new NotExpression((Expression)new SymbolReference("Y")), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference("Z")), (Object)new NotExpression((Expression)new SymbolReference("V")))))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y"))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y"))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BigintType.BIGINT, (Object)"Y", (Object)BigintType.BIGINT));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y"))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)DoubleType.DOUBLE, (Object)"Y", (Object)DoubleType.DOUBLE));
        TestSimplifyExpressions.assertSimplifies((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("X"), (Expression)new SymbolReference("Y"))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)VarcharType.VARCHAR, (Object)"Y", (Object)VarcharType.VARCHAR));
    }

    @Test
    public void testExtractCommonPredicates() {
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("Y"), (Object)new SymbolReference("X"))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("X"))), (Expression)new SymbolReference("X"), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("X"))), (Expression)new SymbolReference("X"), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("V"))), (Object)new SymbolReference("V"))), (Expression)new SymbolReference("V"), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("V"))), (Object)new SymbolReference("V"))), (Expression)new SymbolReference("V"), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"), (Object)new SymbolReference("C"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"), (Object)new SymbolReference("C"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("I"), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"), (Object)new SymbolReference("C")))))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("I"), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B")))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"I", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Z"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Z"))))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"), (Object)new SymbolReference("V"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"), (Object)new SymbolReference("Z"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("V"), (Object)new SymbolReference("Z"))))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"), (Object)new SymbolReference("V"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"), (Object)new SymbolReference("Z"))))), (Expression)new SymbolReference("I")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("V"), (Object)new SymbolReference("Z"))))), (Expression)new SymbolReference("I")), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN, (Object)"I", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("V"))), (Object)new SymbolReference("V"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("V"))), (Object)new SymbolReference("V"))))), (Expression)new SymbolReference("V"), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("V"))), (Object)new SymbolReference("X"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("V"))), (Object)new SymbolReference("V"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("V"))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("V"))), (Object)new SymbolReference("Z"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("V"))), (Object)new SymbolReference("V"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("V"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("Z"), (Object)new SymbolReference("V"))))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("Y"), (Object)new SymbolReference("Z"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("Y"), (Object)new SymbolReference("V"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("Y"), (Object)new SymbolReference("X"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("X"), (Object)new SymbolReference("Y"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("Z"), (Object)new SymbolReference("V"), (Object)new SymbolReference("X"))))), (Map<String, Type>)ImmutableMap.of((Object)"X", (Object)BooleanType.BOOLEAN, (Object)"Y", (Object)BooleanType.BOOLEAN, (Object)"Z", (Object)BooleanType.BOOLEAN, (Object)"V", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"), (Object)new SymbolReference("C"), (Object)new SymbolReference("D"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"), (Object)new SymbolReference("E"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("F"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("B"), (Object)new SymbolReference("C"), (Object)new SymbolReference("D"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("B"), (Object)new SymbolReference("E"))), (Object)new SymbolReference("F"))))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN, (Object)"E", (Object)BooleanType.BOOLEAN, (Object)"F", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("C"))))), (Object)new SymbolReference("D"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("B"), (Object)new SymbolReference("C"))), (Object)new SymbolReference("D"))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("C"))))), (Object)new SymbolReference("D"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"), (Object)new SymbolReference("D"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("C"), (Object)new SymbolReference("D"))))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("C"))))), (Object)new SymbolReference("D"))), (Object)new SymbolReference("E"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("E"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("B"), (Object)new SymbolReference("C"), (Object)new SymbolReference("E"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("D"), (Object)new SymbolReference("E"))))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN, (Object)"E", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("C"))))), (Object)new SymbolReference("D"))), (Object)new SymbolReference("E"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("B"), (Object)new SymbolReference("C"))), (Object)new SymbolReference("D"))), (Object)new SymbolReference("E"))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN, (Object)"E", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("C"), (Object)new SymbolReference("D"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("C"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("D"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("B"), (Object)new SymbolReference("C"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("B"), (Object)new SymbolReference("D"))))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("C"), (Object)new SymbolReference("D"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("E"), (Object)new SymbolReference("F"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A"), (Object)new SymbolReference("B"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("C"), (Object)new SymbolReference("D"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("E"), (Object)new SymbolReference("F"))))), (Map<String, Type>)ImmutableMap.of((Object)"A", (Object)BooleanType.BOOLEAN, (Object)"B", (Object)BooleanType.BOOLEAN, (Object)"C", (Object)BooleanType.BOOLEAN, (Object)"D", (Object)BooleanType.BOOLEAN, (Object)"E", (Object)BooleanType.BOOLEAN, (Object)"F", (Object)BooleanType.BOOLEAN));
        Map symbolTypes = (Map)IntStream.range(1, 61).mapToObj(i -> "A" + i).collect(ImmutableMap.toImmutableMap(Function.identity(), x -> BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A1"), (Object)new SymbolReference("A2"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A3"), (Object)new SymbolReference("A4"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A5"), (Object)new SymbolReference("A6"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A7"), (Object)new SymbolReference("A8"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A9"), (Object)new SymbolReference("A10"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A11"), (Object)new SymbolReference("A12"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A13"), (Object)new SymbolReference("A14"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A15"), (Object)new SymbolReference("A16"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A17"), (Object)new SymbolReference("A18"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A19"), (Object)new SymbolReference("A20"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A21"), (Object)new SymbolReference("A22"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A23"), (Object)new SymbolReference("A24"))), (Object[])new Expression[]{new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A25"), (Object)new SymbolReference("A26"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A27"), (Object)new SymbolReference("A28"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A29"), (Object)new SymbolReference("A30"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A31"), (Object)new SymbolReference("A32"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A33"), (Object)new SymbolReference("A34"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A35"), (Object)new SymbolReference("A36"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A37"), (Object)new SymbolReference("A38"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A39"), (Object)new SymbolReference("A40"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A41"), (Object)new SymbolReference("A42"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A43"), (Object)new SymbolReference("A44"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A45"), (Object)new SymbolReference("A46"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A47"), (Object)new SymbolReference("A48"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A49"), (Object)new SymbolReference("A50"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A51"), (Object)new SymbolReference("A52"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A53"), (Object)new SymbolReference("A54"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A55"), (Object)new SymbolReference("A56"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A57"), (Object)new SymbolReference("A58"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A59"), (Object)new SymbolReference("A60")))})), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A1"), (Object)new SymbolReference("A2"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A3"), (Object)new SymbolReference("A4"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A5"), (Object)new SymbolReference("A6"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A7"), (Object)new SymbolReference("A8"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A9"), (Object)new SymbolReference("A10"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A11"), (Object)new SymbolReference("A12"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A13"), (Object)new SymbolReference("A14"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A15"), (Object)new SymbolReference("A16"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A17"), (Object)new SymbolReference("A18"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A19"), (Object)new SymbolReference("A20"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A21"), (Object)new SymbolReference("A22"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A23"), (Object)new SymbolReference("A24"))), (Object[])new Expression[]{new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A25"), (Object)new SymbolReference("A26"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A27"), (Object)new SymbolReference("A28"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A29"), (Object)new SymbolReference("A30"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A31"), (Object)new SymbolReference("A32"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A33"), (Object)new SymbolReference("A34"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A35"), (Object)new SymbolReference("A36"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A37"), (Object)new SymbolReference("A38"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A39"), (Object)new SymbolReference("A40"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A41"), (Object)new SymbolReference("A42"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A43"), (Object)new SymbolReference("A44"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A45"), (Object)new SymbolReference("A46"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A47"), (Object)new SymbolReference("A48"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A49"), (Object)new SymbolReference("A50"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A51"), (Object)new SymbolReference("A52"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A53"), (Object)new SymbolReference("A54"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A55"), (Object)new SymbolReference("A56"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A57"), (Object)new SymbolReference("A58"))), new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("A59"), (Object)new SymbolReference("A60")))})), symbolTypes);
    }

    @Test
    public void testMultipleNulls() {
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral(), (Object)new NullLiteral(), (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral(), (Object)new NullLiteral(), (Object)new SymbolReference("B1"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NullLiteral(), (Object)new SymbolReference("B1"))), (Map<String, Type>)ImmutableMap.of((Object)"B1", (Object)BooleanType.BOOLEAN));
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral(), (Object)new NullLiteral(), (Object)BooleanLiteral.TRUE_LITERAL)), (Expression)BooleanLiteral.TRUE_LITERAL);
        TestSimplifyExpressions.assertSimplifies((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral(), (Object)new NullLiteral(), (Object)new SymbolReference("B1"))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NullLiteral(), (Object)new SymbolReference("B1"))), (Map<String, Type>)ImmutableMap.of((Object)"B1", (Object)BooleanType.BOOLEAN));
    }

    @Test
    public void testCastBigintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new LongLiteral(12300000000L), (Type)VarcharType.createVarcharType((int)11)), (Expression)new StringLiteral("12300000000"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new LongLiteral(-12300000000L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Cast((Expression)new StringLiteral("-12300000000"), (Type)VarcharType.createVarcharType((int)50)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new LongLiteral(12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new LongLiteral(12300000000L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new LongLiteral(-12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new LongLiteral(-12300000000L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new LongLiteral(12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("12300000000")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new LongLiteral(12300000000L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("12300000000")));
    }

    @Test
    public void testCastIntegerToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new LongLiteral(1234L), (Type)VarcharType.createVarcharType((int)4)), (Expression)new StringLiteral("1234"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new LongLiteral(-1234L), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Cast((Expression)new StringLiteral("-1234"), (Type)VarcharType.createVarcharType((int)50)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new LongLiteral(1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new LongLiteral(1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new LongLiteral(-1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new LongLiteral(-1234L), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new LongLiteral(1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("1234")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new LongLiteral(1234L), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("1234")));
    }

    @Test
    public void testCastSmallintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1234"), (Type)VarcharType.createVarcharType((int)4)), (Expression)new StringLiteral("1234"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-1234"), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Cast((Expression)new StringLiteral("-1234"), (Type)VarcharType.createVarcharType((int)50)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1234"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1234"), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-1234"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "-1234"), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1234"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("1234")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new GenericLiteral((Type)SmallintType.SMALLINT, "1234"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("1234")));
    }

    @Test
    public void testCastTinyintToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)TinyintType.TINYINT, "123"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("123"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)TinyintType.TINYINT, "-123"), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Cast((Expression)new StringLiteral("-123"), (Type)VarcharType.createVarcharType((int)50)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)TinyintType.TINYINT, "123"), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new GenericLiteral((Type)TinyintType.TINYINT, "123"), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)TinyintType.TINYINT, "-123"), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new GenericLiteral((Type)TinyintType.TINYINT, "-123"), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new GenericLiteral((Type)TinyintType.TINYINT, "123"), (Type)VarcharType.createVarcharType((int)2)), (Expression)new StringLiteral("123")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new GenericLiteral((Type)TinyintType.TINYINT, "123"), (Type)VarcharType.createVarcharType((int)2)), (Expression)new StringLiteral("123")));
    }

    @Test
    public void testCastShortDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DecimalLiteral("12.4"), (Type)VarcharType.createVarcharType((int)4)), (Expression)new StringLiteral("12.4"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DecimalLiteral("-12.4"), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Cast((Expression)new StringLiteral("-12.4"), (Type)VarcharType.createVarcharType((int)50)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DecimalLiteral("12.4"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new DecimalLiteral("12.4"), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DecimalLiteral("-12.4"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new DecimalLiteral("-12.4"), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new DecimalLiteral("12.4"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("12.4")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new DecimalLiteral("12.4"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("12.4")));
    }

    @Test
    public void testCastLongDecimalToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DecimalLiteral("100000000000000000.1"), (Type)VarcharType.createVarcharType((int)20)), (Expression)new StringLiteral("100000000000000000.1"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DecimalLiteral("-100000000000000000.1"), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Cast((Expression)new StringLiteral("-100000000000000000.1"), (Type)VarcharType.createVarcharType((int)50)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DecimalLiteral("100000000000000000.1"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new DecimalLiteral("100000000000000000.1"), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DecimalLiteral("-100000000000000000.1"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new DecimalLiteral("-100000000000000000.1"), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new DecimalLiteral("100000000000000000.1"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("100000000000000000.1")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new DecimalLiteral("100000000000000000.1"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("100000000000000000.1")));
    }

    @Test
    public void testCastDoubleToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DoubleLiteral(0.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("0E0"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DoubleLiteral(-0.0), (Type)VarcharType.createVarcharType((int)4)), (Expression)new StringLiteral("-0E0"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new DoubleLiteral(0.0), (Expression)new DoubleLiteral(0.0)), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("NaN"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "Infinity"), (Type)VarcharType.createVarcharType((int)8)), (Expression)new StringLiteral("Infinity"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DoubleLiteral(1200.0), (Type)VarcharType.createVarcharType((int)5)), (Expression)new StringLiteral("1.2E3"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DoubleLiteral(-1200.0), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Cast((Expression)new StringLiteral("-1.2E3"), (Type)VarcharType.createVarcharType((int)50)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DoubleLiteral(1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new DoubleLiteral(1200.0), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DoubleLiteral(-1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new DoubleLiteral(-1200.0), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new DoubleLiteral(Double.NaN), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new DoubleLiteral(Double.NaN), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "Infinity"), (Type)VarcharType.createVarcharType((int)7)), (Expression)new Cast((Expression)new GenericLiteral((Type)DoubleType.DOUBLE, "Infinity"), (Type)VarcharType.createVarcharType((int)7)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new DoubleLiteral(1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("1200.0")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new DoubleLiteral(1200.0), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("1200.0")));
    }

    @Test
    public void testCastRealToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "0e0"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("0E0"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "-0e0"), (Type)VarcharType.createVarcharType((int)4)), (Expression)new StringLiteral("-0E0"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.DIVIDE, (Expression)new GenericLiteral((Type)RealType.REAL, "0e0"), (Expression)new GenericLiteral((Type)RealType.REAL, "0e0")), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("NaN"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "Infinity"), (Type)VarcharType.createVarcharType((int)8)), (Expression)new StringLiteral("Infinity"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "12e2"), (Type)VarcharType.createVarcharType((int)5)), (Expression)new StringLiteral("1.2E3"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "-12e2"), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Cast((Expression)new StringLiteral("-1.2E3"), (Type)VarcharType.createVarcharType((int)50)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "12e2"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "12e2"), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "-12e2"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "-12e2"), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "NaN"), (Type)VarcharType.createVarcharType((int)2)), (Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "NaN"), (Type)VarcharType.createVarcharType((int)2)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "Infinity"), (Type)VarcharType.createVarcharType((int)7)), (Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "Infinity"), (Type)VarcharType.createVarcharType((int)7)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "12e2"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("1200.0")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new GenericLiteral((Type)RealType.REAL, "12e2"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("1200.0")));
    }

    @Test
    public void testCastDateToBoundedVarchar() {
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)DateType.DATE, "2013-02-02"), (Type)VarcharType.createVarcharType((int)10)), (Expression)new StringLiteral("2013-02-02"));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)DateType.DATE, "2013-02-02"), (Type)VarcharType.createVarcharType((int)50)), (Expression)new Cast((Expression)new StringLiteral("2013-02-02"), (Type)VarcharType.createVarcharType((int)50)));
        TestSimplifyExpressions.assertSimplifies((Expression)new Cast((Expression)new GenericLiteral((Type)DateType.DATE, "2013-02-02"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new Cast((Expression)new GenericLiteral((Type)DateType.DATE, "2013-02-02"), (Type)VarcharType.createVarcharType((int)3)));
        TestSimplifyExpressions.assertSimplifies((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new GenericLiteral((Type)DateType.DATE, "2013-02-02"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("2013-02-02")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new Cast((Expression)new GenericLiteral((Type)DateType.DATE, "2013-02-02"), (Type)VarcharType.createVarcharType((int)3)), (Expression)new StringLiteral("2013-02-02")));
    }

    private static void assertSimplifies(Expression expression, Expression expected) {
        TestSimplifyExpressions.assertSimplifies(expression, expected, (Map<String, Type>)ImmutableMap.of());
    }

    private static void assertSimplifies(Expression expression, Expression expected, Map<String, Type> symbolTypes) {
        Map symbols = (Map)symbolTypes.entrySet().stream().collect(ImmutableMap.toImmutableMap(symbolTypeEntry -> new Symbol((String)symbolTypeEntry.getKey()), Map.Entry::getValue));
        Expression simplified = TestSimplifyExpressions.normalize(SimplifyExpressions.rewrite((Expression)expression, (Session)SessionTestUtils.TEST_SESSION, (SymbolAllocator)new SymbolAllocator(symbols), (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (IrTypeAnalyzer)new IrTypeAnalyzer(TestingPlannerContext.PLANNER_CONTEXT)));
        Assertions.assertThat((Object)simplified).isEqualTo((Object)TestSimplifyExpressions.normalize(expected));
    }

    @Test
    public void testPushesDownNegationsNumericTypes() {
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("I3"), (Expression)new SymbolReference("I4"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("I3"), (Expression)new SymbolReference("I4")))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("I3"), (Expression)new SymbolReference("I4")))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("I3"), (Expression)new SymbolReference("I4")))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("B1"), (Object)new SymbolReference("B2"))), (Object)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("B3"), (Object)new SymbolReference("B4"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference("B1")), (Object)new NotExpression((Expression)new SymbolReference("B2")))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("B3"), (Object)new SymbolReference("B4"))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2")))))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2")))))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new NotExpression((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2")))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2")), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("B1"), (Object)new SymbolReference("B2"))), (Object)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("B3"), (Object)new SymbolReference("B4"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference("B1")), (Object)new NotExpression((Expression)new SymbolReference("B2")))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("B3"), (Object)new SymbolReference("B4"))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("B1"), (Object)new SymbolReference("B2"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2"))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new NotExpression((Expression)new SymbolReference("B1")), (Object)new NotExpression((Expression)new SymbolReference("B2")))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new SymbolReference("R2"))))))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new IfExpression((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2"))), (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2")), (Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("I1"), (Expression)new SymbolReference("I2")), (Expression)new SymbolReference("D1"), (Expression)new SymbolReference("D2")));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new LongLiteral(1L))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("D1"), (Expression)new LongLiteral(1L))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("D2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("D2"))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new LongLiteral(1L))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("R1"), (Expression)new LongLiteral(1L))));
        TestSimplifyExpressions.assertSimplifiesNumericTypes((Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("R2"))), (Expression)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(1L), (Expression)new SymbolReference("R2"))));
    }

    private static void assertSimplifiesNumericTypes(Expression expression, Expression expected) {
        Expression rewritten = SimplifyExpressions.rewrite((Expression)expression, (Session)SessionTestUtils.TEST_SESSION, (SymbolAllocator)new SymbolAllocator(TestSimplifyExpressions.numericAndBooleanSymbolTypeMapFor(expression)), (PlannerContext)TestingPlannerContext.PLANNER_CONTEXT, (IrTypeAnalyzer)new IrTypeAnalyzer(TestingPlannerContext.PLANNER_CONTEXT));
        Assertions.assertThat((Object)TestSimplifyExpressions.normalize(rewritten)).isEqualTo((Object)TestSimplifyExpressions.normalize(expected));
    }

    private static Map<Symbol, Type> numericAndBooleanSymbolTypeMapFor(Expression expression) {
        return SymbolsExtractor.extractUnique((Expression)expression).stream().collect(Collectors.toMap(symbol -> symbol, symbol -> {
            switch (symbol.getName().charAt(0)) {
                case 'I': {
                    return IntegerType.INTEGER;
                }
                case 'D': {
                    return DoubleType.DOUBLE;
                }
                case 'R': {
                    return RealType.REAL;
                }
                case 'B': {
                    return BooleanType.BOOLEAN;
                }
            }
            return BigintType.BIGINT;
        }));
    }

    private static Expression normalize(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new NormalizeExpressionRewriter(), (Expression)expression);
    }

    private static class NormalizeExpressionRewriter
    extends ExpressionRewriter<Void> {
        private NormalizeExpressionRewriter() {
        }

        public Expression rewriteLogicalExpression(LogicalExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            List predicates = IrUtils.extractPredicates((LogicalExpression.Operator)node.getOperator(), (Expression)node).stream().map(p -> treeRewriter.rewrite(p, (Object)context)).sorted(Comparator.comparing(Object::toString)).collect(Collectors.toList());
            return IrUtils.logicalExpression((LogicalExpression.Operator)node.getOperator(), predicates);
        }

        public Expression rewriteCast(Cast node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
            return new Cast(node.getExpression(), node.getType(), node.isSafe());
        }
    }
}

