/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NotExpression;
import io.trino.sql.ir.NullIfExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.SearchedCaseExpression;
import io.trino.sql.ir.SimpleCaseExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.ir.WhenClause;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.SimplifyFilterPredicate;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestSimplifyFilterPredicate
extends BaseRuleTest {
    public TestSimplifyFilterPredicate() {
        super(new Plugin[0]);
    }

    @Test
    public void testSimplifyIfExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.FALSE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference("a"), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new NullLiteral()), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference("a"), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)BooleanLiteral.FALSE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new SymbolReference("a")))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)new NullLiteral(), (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("a")), (Object)new NotExpression((Expression)new SymbolReference("a")))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)BooleanLiteral.FALSE_LITERAL, (Expression)BooleanLiteral.FALSE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L))), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L)), PlanMatchPattern.values("a", "b")));
        FunctionCall randomFunction = new FunctionCall(this.tester().getMetadata().resolveBuiltinFunction("random", (List)ImmutableList.of()).toQualifiedName(), (List)ImmutableList.of());
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)randomFunction, (Expression)new LongLiteral(0L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)randomFunction, (Expression)new LongLiteral(0L))), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)new NullLiteral()), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference("a"), (Expression)new NotExpression((Expression)new SymbolReference("a"))), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference("a"), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference("a"), (Expression)new NotExpression((Expression)new SymbolReference("a"))), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new NotExpression((Expression)new SymbolReference("a")), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference("a")), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference("b")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
    }

    @Test
    public void testSimplifyNullIfExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new NullIfExpression((Expression)new SymbolReference("a"), (Expression)new SymbolReference("b")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new SymbolReference("b")), (Object)new NotExpression((Expression)new SymbolReference("b")))))), PlanMatchPattern.values("a", "b")));
    }

    @Test
    public void testSimplifySearchedCaseExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(BooleanLiteral.TRUE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)new NullLiteral()), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)new NullLiteral()), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.empty()), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)new NullLiteral()), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))))), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)new NullLiteral()), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)new NullLiteral()), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(BooleanLiteral.TRUE_LITERAL)), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new IsNullPredicate((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))), (Object)new NotExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("a"), (Expression)new LongLiteral(0L))))))), PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference("a")), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference("a")), (Object)new WhenClause((Expression)new NullLiteral(), (Expression)new SymbolReference("a"))), Optional.of(new SymbolReference("b"))), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference("b"), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference("a")), (Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new NotExpression((Expression)new SymbolReference("a"))), (Object)new WhenClause((Expression)new NullLiteral(), (Expression)new SymbolReference("a"))), Optional.empty()), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference("a")), (Object)new WhenClause((Expression)new NullLiteral(), (Expression)new NotExpression((Expression)new SymbolReference("a"))), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference("b"))), Optional.empty()), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference("b"), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new SymbolReference("a")), (Object)new WhenClause((Expression)new SymbolReference("b"), (Expression)new NotExpression((Expression)new SymbolReference("a"))), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference("b"))), Optional.empty()), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new SymbolReference("b"), (Expression)new NotExpression((Expression)new SymbolReference("a")))), Optional.of(new SymbolReference("b"))), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L)), (Expression)new SymbolReference("a")), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L)), (Expression)new NotExpression((Expression)new SymbolReference("a"))), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new SymbolReference("b")), (Object)new WhenClause((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)new NotExpression((Expression)new SymbolReference("b")))), Optional.empty()), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L)), (Expression)new SymbolReference("a")), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L)), (Expression)new NotExpression((Expression)new SymbolReference("a")))), Optional.of(new SymbolReference("b"))), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SearchedCaseExpression((List)ImmutableList.of((Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L)), (Expression)new SymbolReference("a")), (Object)new WhenClause((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(0L)), (Expression)new NotExpression((Expression)new SymbolReference("a")))), Optional.of(new SymbolReference("b"))), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
    }

    @Test
    public void testSimplifySimpleCaseExpression() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new SymbolReference("a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new SymbolReference("b"), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(1L)), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(BooleanLiteral.TRUE_LITERAL)), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).doesNotFire();
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new NullLiteral(), (List)ImmutableList.of((Object)new WhenClause((Expression)new NullLiteral(), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new SymbolReference("a"), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.of(new SymbolReference("b"))), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)new SymbolReference("b"), PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new NullLiteral(), (List)ImmutableList.of((Object)new WhenClause((Expression)new NullLiteral(), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new SymbolReference("a"), (Expression)BooleanLiteral.FALSE_LITERAL)), Optional.empty()), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new SymbolReference("a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(1L)), (Expression)BooleanLiteral.TRUE_LITERAL), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(2L)), (Expression)BooleanLiteral.TRUE_LITERAL)), Optional.of(BooleanLiteral.TRUE_LITERAL)), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new SymbolReference("a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(1L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(2L)), (Expression)new NullLiteral())), Optional.of(BooleanLiteral.FALSE_LITERAL)), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a", "b")));
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new SimpleCaseExpression((Expression)new SymbolReference("a"), (List)ImmutableList.of((Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(1L)), (Expression)BooleanLiteral.FALSE_LITERAL), (Object)new WhenClause((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("b"), (Expression)new LongLiteral(2L)), (Expression)new NullLiteral())), Optional.empty()), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a", "b")));
    }

    @Test
    public void testCastNull() {
        this.tester().assertThat((Rule<?>)new SimplifyFilterPredicate(this.tester().getMetadata())).on(p -> p.filter((Expression)new IfExpression((Expression)new SymbolReference("a"), (Expression)new Cast((Expression)new Cast((Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN), (Type)BigintType.BIGINT), (Type)BooleanType.BOOLEAN), (Expression)BooleanLiteral.FALSE_LITERAL), (PlanNode)p.values(p.symbol("a")))).matches(PlanMatchPattern.filter((Expression)BooleanLiteral.FALSE_LITERAL, PlanMatchPattern.values("a")));
    }
}

