/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedGroupedAggregationWithProjection;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedGroupedAggregationWithProjection
extends BaseRuleTest {
    public TestTransformCorrelatedGroupedAggregationWithProjection() {
        super(new Plugin[0]);
    }

    @Test
    public void doesNotFireOnUncorrelated() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("b")))).doesNotFire();
    }

    @Test
    public void doesNotFireOnCorrelatedWithNonGroupedAggregation() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("sum")}), (PlanNode)p.aggregation(ab -> ab.source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).globalGrouping())))).doesNotFire();
    }

    @Test
    public void rewritesOnSubqueryWithoutDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_sum"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum"), (Expression)new LongLiteral(1L)), (Symbol)p.symbol("expr_count"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("count"), (Expression)new LongLiteral(1L))), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.singleGroupingSet(p.symbol("a")).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).source((PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("corr")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"expr_sum", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum_agg"), (Expression)new LongLiteral(1L))), (Object)"expr_count", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("count_agg"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("corr"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a", "b")))))));
    }

    @Test
    public void rewritesOnSubqueryWithDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_sum"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum"), (Expression)new LongLiteral(1L)), (Symbol)p.symbol("expr_count"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("count"), (Expression)new LongLiteral(1L))), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.singleGroupingSet(p.symbol("a")).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("corr")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"expr_sum", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum_agg"), (Expression)new LongLiteral(1L))), (Object)"expr_count", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("count_agg"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("corr"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a", "b"))))))));
    }

    @Test
    public void rewritesOnSubqueryWithDecorrelatableDistinct() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedGroupedAggregationWithProjection(this.tester().getPlannerContext())).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("corr")), (PlanNode)p.values(p.symbol("corr")), JoinType.INNER, (Expression)BooleanLiteral.TRUE_LITERAL, (PlanNode)p.project(Assignments.of((Symbol)p.symbol("expr_sum"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum"), (Expression)new LongLiteral(1L)), (Symbol)p.symbol("expr_count"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("count"), (Expression)new LongLiteral(1L))), (PlanNode)p.aggregation(outerBuilder -> outerBuilder.singleGroupingSet(p.symbol("a")).addAggregation(p.symbol("sum"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new SymbolReference("a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("count"), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).source((PlanNode)p.aggregation(innerBuilder -> innerBuilder.singleGroupingSet(p.symbol("a")).source((PlanNode)p.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("corr")), (PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"corr", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("corr")), (Object)"expr_sum", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("sum_agg"), (Expression)new LongLiteral(1L))), (Object)"expr_count", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new SymbolReference("count_agg"), (Expression)new LongLiteral(1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("corr", "unique", "a"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(Optional.of("sum_agg"), PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), Optional.of("count_agg"), PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.join(JoinType.INNER, builder -> builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("corr"))).left(PlanMatchPattern.assignUniqueId("unique", PlanMatchPattern.values("corr"))).right(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("a", "b"), (Map<Optional<String>, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), Optional.empty(), AggregationNode.Step.SINGLE, PlanMatchPattern.filter((Expression)BooleanLiteral.TRUE_LITERAL, PlanMatchPattern.values("a", "b"))))))));
    }
}

