/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.TransformCorrelatedSingleRowSubqueryToProject;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestTransformCorrelatedSingleRowSubqueryToProject
extends BaseRuleTest {
    public TestTransformCorrelatedSingleRowSubqueryToProject() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.values(p.symbol("a"))).doesNotFire();
    }

    @Test
    public void testRewrite() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("l_nationkey")), (PlanNode)p.tableScan(this.tester().getCurrentCatalogTableHandle("tiny", "nation"), (List<Symbol>)ImmutableList.of((Object)p.symbol("l_nationkey")), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)p.symbol("l_nationkey"), (Object)new TpchColumnHandle("nationkey", (Type)BigintType.BIGINT))), (PlanNode)p.project(Assignments.of((Symbol)p.symbol("l_expr2"), (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("l_nationkey"), (Expression)new LongLiteral(1L))), (PlanNode)p.values((List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of()))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"l_expr2", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("l_nationkey"), (Expression)new LongLiteral(1L))), (Object)"l_nationkey", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("l_nationkey"))), PlanMatchPattern.tableScan("nation", (Map<String, String>)ImmutableMap.of((Object)"l_nationkey", (Object)"nationkey"))));
    }

    @Test
    public void testDoesNotFireWithEmptyValuesNode() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)p.symbol("a")), (PlanNode)p.values(p.symbol("a")), (PlanNode)p.values(p.symbol("a")))).doesNotFire();
    }

    @Test
    public void testCorrelatedValues() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(3, a), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new SymbolReference("a")))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a"))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral())))));
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            Symbol c = p.symbol("c");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(3, a, b), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)c), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new SymbolReference("a"), (Object)new LongLiteral(1L)))));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("b")), (Object)"c", (Object)PlanMatchPattern.expression((Expression)new LongLiteral(1L))), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral(), (Object)new NullLiteral())))));
    }

    @Test
    public void testUncorrelatedValues() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of(), (PlanNode)p.values(3, a), (PlanNode)p.values(1, b));
        }).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new NullLiteral())), PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral()), (Object)ImmutableList.of((Object)new NullLiteral())))));
    }

    @Test
    public void testMultipleRowValues() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(3, a), (PlanNode)p.values(2, b));
        }).doesNotFire();
    }

    @Test
    public void testNonRowValues() {
        this.tester().assertThat((Rule<?>)new TransformCorrelatedSingleRowSubqueryToProject()).on(p -> {
            Symbol a = p.symbol("a");
            return p.correlatedJoin((List<Symbol>)ImmutableList.of((Object)a), (PlanNode)p.values(3, a), (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)p.symbol("b")), (List<Expression>)ImmutableList.of((Object)new Cast((Expression)new Row((List)ImmutableList.of((Object)new StringLiteral("true"))), (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"col", (Type)BooleanType.BOOLEAN)})))));
        }).doesNotFire();
    }
}

