/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SubscriptExpression;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.SetExpressionMatcher;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.UnwrapSingleColumnRowInApply;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.ApplyNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestUnwrapSingleColumnRowInApply
extends BaseRuleTest {
    public TestUnwrapSingleColumnRowInApply() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireOnNoSingleColumnRow() {
        this.tester().assertThat((Rule<?>)new UnwrapSingleColumnRowInApply(new IrTypeAnalyzer(this.tester().getPlannerContext()))).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.builder().put((Object)p.symbol("output1", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.In(new Symbol("value"), new Symbol("element"))).put((Object)p.symbol("output2", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.QuantifiedComparison(ApplyNode.Operator.EQUAL, ApplyNode.Quantifier.ALL, new Symbol("value"), new Symbol("element"))).buildOrThrow(), Collections.emptyList(), (PlanNode)p.values(p.symbol("value", (Type)IntegerType.INTEGER)), (PlanNode)p.values(p.symbol("element", (Type)IntegerType.INTEGER)))).doesNotFire();
    }

    @Test
    public void testUnwrapInPredicate() {
        this.tester().assertThat((Rule<?>)new UnwrapSingleColumnRowInApply(new IrTypeAnalyzer(this.tester().getPlannerContext()))).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.builder().put((Object)p.symbol("unwrapped", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.In(new Symbol("rowValue"), new Symbol("rowElement"))).put((Object)p.symbol("notUnwrapped", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.In(new Symbol("nonRowValue"), new Symbol("nonRowElement"))).buildOrThrow(), Collections.emptyList(), (PlanNode)p.values(p.symbol("rowValue", (Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER})), p.symbol("nonRowValue", (Type)IntegerType.INTEGER)), (PlanNode)p.values(p.symbol("rowElement", (Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER})), p.symbol("nonRowElement", (Type)IntegerType.INTEGER)))).matches(PlanMatchPattern.project(PlanMatchPattern.apply(List.of(), (Map<String, SetExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrapped", (Object)PlanMatchPattern.setExpression((ApplyNode.SetExpression)new ApplyNode.In(new Symbol("unwrappedValue"), new Symbol("unwrappedElement")))).put((Object)"notUnwrapped", (Object)PlanMatchPattern.setExpression((ApplyNode.SetExpression)new ApplyNode.In(new Symbol("nonRowValue"), new Symbol("nonRowElement")))).buildOrThrow(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrappedValue", (Object)PlanMatchPattern.expression((Expression)new SubscriptExpression((Expression)new SymbolReference("rowValue"), (Expression)new LongLiteral(1L)))).put((Object)"nonRowValue", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("nonRowValue"))).buildOrThrow(), PlanMatchPattern.values("rowValue", "nonRowValue")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrappedElement", (Object)PlanMatchPattern.expression((Expression)new SubscriptExpression((Expression)new SymbolReference("rowElement"), (Expression)new LongLiteral(1L)))).put((Object)"nonRowElement", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("nonRowElement"))).buildOrThrow(), PlanMatchPattern.values("rowElement", "nonRowElement")))));
    }

    @Test
    public void testUnwrapQuantifiedComparison() {
        this.tester().assertThat((Rule<?>)new UnwrapSingleColumnRowInApply(new IrTypeAnalyzer(this.tester().getPlannerContext()))).on(p -> p.apply((Map<Symbol, ApplyNode.SetExpression>)ImmutableMap.builder().put((Object)p.symbol("unwrapped", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.QuantifiedComparison(ApplyNode.Operator.EQUAL, ApplyNode.Quantifier.ALL, new Symbol("rowValue"), new Symbol("rowElement"))).put((Object)p.symbol("notUnwrapped", (Type)BooleanType.BOOLEAN), (Object)new ApplyNode.QuantifiedComparison(ApplyNode.Operator.EQUAL, ApplyNode.Quantifier.ALL, new Symbol("nonRowValue"), new Symbol("nonRowElement"))).buildOrThrow(), Collections.emptyList(), (PlanNode)p.values(p.symbol("rowValue", (Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER})), p.symbol("nonRowValue", (Type)IntegerType.INTEGER)), (PlanNode)p.values(p.symbol("rowElement", (Type)RowType.anonymousRow((Type[])new Type[]{IntegerType.INTEGER})), p.symbol("nonRowElement", (Type)IntegerType.INTEGER)))).matches(PlanMatchPattern.project(PlanMatchPattern.apply(List.of(), (Map<String, SetExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrapped", (Object)PlanMatchPattern.setExpression((ApplyNode.SetExpression)new ApplyNode.QuantifiedComparison(ApplyNode.Operator.EQUAL, ApplyNode.Quantifier.ALL, new Symbol("unwrappedValue"), new Symbol("unwrappedElement")))).put((Object)"notUnwrapped", (Object)PlanMatchPattern.setExpression((ApplyNode.SetExpression)new ApplyNode.QuantifiedComparison(ApplyNode.Operator.EQUAL, ApplyNode.Quantifier.ALL, new Symbol("nonRowValue"), new Symbol("nonRowElement")))).buildOrThrow(), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrappedValue", (Object)PlanMatchPattern.expression((Expression)new SubscriptExpression((Expression)new SymbolReference("rowValue"), (Expression)new LongLiteral(1L)))).put((Object)"nonRowValue", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("nonRowValue"))).buildOrThrow(), PlanMatchPattern.values("rowValue", "nonRowValue")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"unwrappedElement", (Object)PlanMatchPattern.expression((Expression)new SubscriptExpression((Expression)new SymbolReference("rowElement"), (Expression)new LongLiteral(1L)))).put((Object)"nonRowElement", (Object)PlanMatchPattern.expression((Expression)new SymbolReference("nonRowElement"))).buildOrThrow(), PlanMatchPattern.values("rowElement", "nonRowElement")))));
    }
}

