/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import io.trino.Session;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.StatsCalculator;
import io.trino.security.AccessControl;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.iterative.rule.test.RuleAssert;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import io.trino.transaction.TransactionId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class RuleBuilder {
    private final Rule<?> rule;
    private final PlanTester planTester;
    private Session session;
    private final TestingStatsCalculator statsCalculator;

    RuleBuilder(Rule<?> rule, PlanTester planTester, Session session) {
        this.rule = Objects.requireNonNull(rule, "rule is null");
        this.planTester = Objects.requireNonNull(planTester, "planTester is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.statsCalculator = new TestingStatsCalculator(planTester.getStatsCalculator());
    }

    public RuleBuilder setSystemProperty(String key, String value) {
        return this.withSession(Session.builder((Session)this.session).setSystemProperty(key, value).build());
    }

    public RuleBuilder withSession(Session session) {
        this.session = session;
        return this;
    }

    public RuleBuilder overrideStats(String nodeId, PlanNodeStatsEstimate nodeStats) {
        this.statsCalculator.setNodeStats(new PlanNodeId(nodeId), nodeStats);
        return this;
    }

    public RuleAssert on(Function<PlanBuilder, PlanNode> planProvider) {
        Session session = TestingSession.testSession((Session)this.session);
        TransactionId transactionId = this.planTester.getTransactionManager().beginTransaction(IsolationLevel.READ_UNCOMMITTED, false, false);
        Session transactionSession = session.beginTransactionId(transactionId, this.planTester.getTransactionManager(), (AccessControl)this.planTester.getAccessControl());
        this.planTester.getPlannerContext().getMetadata().beginQuery(transactionSession);
        try {
            transactionSession.getCatalog().ifPresent(catalog -> this.planTester.getPlannerContext().getMetadata().getCatalogHandle(transactionSession, catalog));
            PlanNodeIdAllocator idAllocator = new PlanNodeIdAllocator();
            PlanBuilder builder = new PlanBuilder(idAllocator, this.planTester.getPlannerContext(), transactionSession);
            PlanNode plan = planProvider.apply(builder);
            TypeProvider types = builder.getTypes();
            return new RuleAssert(this.rule, this.planTester, this.statsCalculator, transactionSession, idAllocator, plan, types);
        }
        catch (Throwable t) {
            this.planTester.getPlannerContext().getMetadata().cleanupQuery(session);
            this.planTester.getTransactionManager().asyncAbort(transactionId);
            throw t;
        }
    }

    private static class TestingStatsCalculator
    implements StatsCalculator {
        private final StatsCalculator delegate;
        private final Map<PlanNodeId, PlanNodeStatsEstimate> stats = new HashMap<PlanNodeId, PlanNodeStatsEstimate>();

        TestingStatsCalculator(StatsCalculator delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        public PlanNodeStatsEstimate calculateStats(PlanNode node, StatsCalculator.Context context) {
            if (this.stats.containsKey(node.getId())) {
                return this.stats.get(node.getId());
            }
            return this.delegate.calculateStats(node, context);
        }

        public void setNodeStats(PlanNodeId nodeId, PlanNodeStatsEstimate nodeStats) {
            this.stats.put(nodeId, nodeStats);
        }
    }
}

