/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule.test;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.split.PageSourceManager;
import io.trino.split.SplitManager;
import io.trino.sql.PlannerContext;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.test.RuleBuilder;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class RuleTester
implements Closeable {
    private final Metadata metadata;
    private final Session session;
    private final PlanTester planTester;
    private final SplitManager splitManager;
    private final PageSourceManager pageSourceManager;
    private final IrTypeAnalyzer typeAnalyzer;
    private final FunctionManager functionManager;

    public static RuleTester defaultRuleTester() {
        return RuleTester.builder().build();
    }

    public RuleTester(PlanTester planTester) {
        this.planTester = Objects.requireNonNull(planTester, "planTester is null");
        this.session = planTester.getDefaultSession();
        this.metadata = planTester.getPlannerContext().getMetadata();
        this.functionManager = planTester.getPlannerContext().getFunctionManager();
        this.splitManager = planTester.getSplitManager();
        this.pageSourceManager = planTester.getPageSourceManager();
        this.typeAnalyzer = new IrTypeAnalyzer(planTester.getPlannerContext());
    }

    public RuleBuilder assertThat(Rule<?> rule) {
        return new RuleBuilder(rule, this.planTester, this.session);
    }

    @Override
    public void close() {
        this.planTester.close();
    }

    public PlannerContext getPlannerContext() {
        return this.planTester.getPlannerContext();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public FunctionManager getFunctionManager() {
        return this.functionManager;
    }

    public Session getSession() {
        return this.session;
    }

    public SplitManager getSplitManager() {
        return this.splitManager;
    }

    public PageSourceManager getPageSourceManager() {
        return this.pageSourceManager;
    }

    public IrTypeAnalyzer getTypeAnalyzer() {
        return this.typeAnalyzer;
    }

    public CatalogHandle getCurrentCatalogHandle() {
        return this.planTester.getCatalogHandle((String)this.session.getCatalog().orElseThrow());
    }

    public TableHandle getCurrentCatalogTableHandle(String schemaName, String tableName) {
        return this.planTester.getTableHandle((String)this.session.getCatalog().orElseThrow(), schemaName, tableName);
    }

    public PlanTester getPlanTester() {
        return this.planTester;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Plugin> plugins = new ArrayList<Plugin>();
        private final Map<String, String> sessionProperties = new HashMap<String, String>();
        private Optional<Integer> nodeCountForStats = Optional.empty();
        private ConnectorFactory defaultCatalogConnectorFactory = new TpchConnectorFactory(1);

        private Builder() {
        }

        public Builder addPlugin(Plugin plugin) {
            this.plugins.add(Objects.requireNonNull(plugin, "plugin is null"));
            return this;
        }

        public Builder addPlugins(List<Plugin> plugins) {
            this.plugins.addAll((Collection<Plugin>)Objects.requireNonNull(plugins, "plugins is null"));
            return this;
        }

        public Builder addSessionProperty(String key, String value) {
            this.sessionProperties.put(Objects.requireNonNull(key, "key is null"), Objects.requireNonNull(value, "value is null"));
            return this;
        }

        public Builder withNodeCountForStats(int count) {
            this.nodeCountForStats = Optional.of(count);
            return this;
        }

        public Builder withDefaultCatalogConnectorFactory(ConnectorFactory defaultCatalogConnectorFactory) {
            this.defaultCatalogConnectorFactory = defaultCatalogConnectorFactory;
            return this;
        }

        public RuleTester build() {
            Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").setSystemProperty("task_concurrency", "1");
            for (Map.Entry<String, String> entry : this.sessionProperties.entrySet()) {
                sessionBuilder.setSystemProperty(entry.getKey(), entry.getValue());
            }
            Session session = sessionBuilder.build();
            PlanTester planTester = this.nodeCountForStats.map(nodeCount -> PlanTester.create((Session)session, (int)nodeCount)).orElseGet(() -> PlanTester.create((Session)session));
            planTester.createCatalog((String)session.getCatalog().orElseThrow(), this.defaultCatalogConnectorFactory, (Map)ImmutableMap.of());
            this.plugins.forEach(arg_0 -> ((PlanTester)planTester).installPlugin(arg_0));
            return new RuleTester(planTester);
        }
    }
}

