/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.ImmutableLongArray;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimator;
import io.trino.operator.RetryPolicy;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.SubPlanMatcher;
import io.trino.sql.planner.plan.PlanFragmentId;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestAdaptivePartitioning
extends BasePlanTest {
    private static final long ONE_MB = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();

    @Test
    public void testCreateTableAs() {
        SubPlanMatcher matcher = SubPlanMatcher.builder().fragmentMatcher(fm -> fm.fragmentId(5)).children(sb -> sb.fragmentMatcher(fm -> fm.fragmentId(6).outputPartitionCount(10).inputPartitionCount(1)).children(sb1 -> sb1.fragmentMatcher(fm -> fm.fragmentId(1).outputPartitionCount(1))), sb -> sb.fragmentMatcher(fm -> fm.fragmentId(7).inputPartitionCount(10).outputPartitionCount(10)).children(sb1 -> sb1.fragmentMatcher(fm -> fm.fragmentId(8).outputPartitionCount(10).inputPartitionCount(1)).children(sb2 -> sb2.fragmentMatcher(fm -> fm.fragmentId(3).outputPartitionCount(1))), sb1 -> sb1.fragmentMatcher(fm -> fm.fragmentId(9).outputPartitionCount(10).inputPartitionCount(1)).children(sb2 -> sb2.fragmentMatcher(fm -> fm.fragmentId(4).outputPartitionCount(1))))).build();
        this.assertAdaptivePlan("SELECT n1.* FROM nation n1\nRIGHT JOIN\n(SELECT n.nationkey FROM (SELECT * FROM lineitem WHERE suppkey BETWEEN 20 and 30) l LEFT JOIN nation n on l.suppkey = n.nationkey) n2\nON n1.nationkey = n2.nationkey + 1\n", this.getSession(), (Map<PlanFragmentId, OutputStatsEstimator.OutputStatsEstimateResult>)ImmutableMap.of((Object)new PlanFragmentId("3"), (Object)this.createRuntimeStats(ImmutableLongArray.of((long)ONE_MB, (long)(ONE_MB * 2L), (long)ONE_MB), 10000L), (Object)new PlanFragmentId("4"), (Object)this.createRuntimeStats(ImmutableLongArray.of((long)ONE_MB, (long)ONE_MB, (long)ONE_MB), 500L), (Object)new PlanFragmentId("1"), (Object)this.createRuntimeStats(ImmutableLongArray.of((long)ONE_MB, (long)ONE_MB, (long)ONE_MB), 500L)), matcher);
    }

    @Test
    public void testSkipBroadcastSubtree() {
        SubPlanMatcher matcher = SubPlanMatcher.builder().fragmentMatcher(fm -> fm.fragmentId(13)).children(sb -> sb.fragmentMatcher(fm -> fm.fragmentId(14).inputPartitionCount(10)).children(sb1 -> sb1.fragmentMatcher(fm -> fm.fragmentId(15).outputPartitionCount(10).inputPartitionCount(10)).children(sb2 -> sb2.fragmentMatcher(fm -> fm.fragmentId(16).outputPartitionCount(10).inputPartitionCount(10)).children(sb3 -> sb3.fragmentMatcher(fm -> fm.fragmentId(17).outputPartitionCount(10).inputPartitionCount(1)).children(sb4 -> sb4.fragmentMatcher(fm -> fm.fragmentId(4).outputPartitionCount(1))), sb3 -> sb3.fragmentMatcher(fm -> fm.fragmentId(18).outputPartitionCount(10))), sb2 -> sb2.fragmentMatcher(fm -> fm.fragmentId(19).outputPartitionCount(10))), sb1 -> sb1.fragmentMatcher(fm -> fm.fragmentId(7)).children(sb2 -> sb2.fragmentMatcher(fm -> fm.fragmentId(8).inputPartitionCount(1)).children(sb3 -> sb3.fragmentMatcher(fm -> fm.fragmentId(9).outputPartitionCount(1).inputPartitionCount(1)).children(sb4 -> sb4.fragmentMatcher(fm -> fm.fragmentId(10).outputPartitionCount(1)), sb4 -> sb4.fragmentMatcher(fm -> fm.fragmentId(11).outputPartitionCount(1))), sb3 -> sb3.fragmentMatcher(fm -> fm.fragmentId(12).outputPartitionCount(1)))))).build();
        this.assertAdaptivePlan("SELECT\n  ps.partkey,\n  sum(ps.supplycost * ps.availqty) AS value\nFROM\n  partsupp ps,\n  supplier s,\n  nation n\nWHERE\n  ps.suppkey = s.suppkey\n  AND s.nationkey = n.nationkey\n  AND n.name = 'GERMANY'\nGROUP BY\n  ps.partkey\nHAVING\n  sum(ps.supplycost * ps.availqty) > (\n    SELECT sum(ps.supplycost * ps.availqty) * 0.0001\n    FROM\n      partsupp ps,\n      supplier s,\n      nation n\n    WHERE\n      ps.suppkey = s.suppkey\n      AND s.nationkey = n.nationkey\n      AND n.name = 'GERMANY'\n  )\nORDER BY\n  value DESC", this.getSession(), (Map<PlanFragmentId, OutputStatsEstimator.OutputStatsEstimateResult>)ImmutableMap.of((Object)new PlanFragmentId("4"), (Object)this.createRuntimeStats(ImmutableLongArray.of((long)ONE_MB, (long)(ONE_MB * 2L), (long)ONE_MB), 10000L), (Object)new PlanFragmentId("10"), (Object)this.createRuntimeStats(ImmutableLongArray.of((long)ONE_MB, (long)ONE_MB, (long)ONE_MB), 500L), (Object)new PlanFragmentId("11"), (Object)this.createRuntimeStats(ImmutableLongArray.of((long)ONE_MB, (long)ONE_MB, (long)ONE_MB), 500L), (Object)new PlanFragmentId("12"), (Object)this.createRuntimeStats(ImmutableLongArray.of((long)ONE_MB, (long)ONE_MB, (long)ONE_MB), 500L)), matcher);
    }

    private Session getSession() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("retry_policy", RetryPolicy.TASK.name()).setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.PARTITIONED.name()).setSystemProperty("fault_tolerant_execution_runtime_adaptive_partitioning_enabled", "true").setSystemProperty("fault_tolerant_execution_max_partition_count", "2").setSystemProperty("fault_tolerant_execution_min_partition_count", "1").setSystemProperty("fault_tolerant_execution_runtime_adaptive_partitioning_partition_count", "10").setSystemProperty("fault_tolerant_execution_runtime_adaptive_partitioning_max_task_size", "1MB").build();
    }

    private OutputStatsEstimator.OutputStatsEstimateResult createRuntimeStats(ImmutableLongArray partitionDataSizes, long outputRowCountEstimate) {
        return new OutputStatsEstimator.OutputStatsEstimateResult(partitionDataSizes, outputRowCountEstimate, "FINISHED", true);
    }
}

