/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.MergePartitioningHandle;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestAddLocalExchangesForPartitionedInsertAndMerge
extends BasePlanTest {
    private static final PartitioningScheme INSERT_PARTITIONING_SCHEME = new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List)ImmutableList.of((Object)new Symbol("year"))), (List)ImmutableList.of((Object)new Symbol("customer"), (Object)new Symbol("year")));
    private static final PartitioningHandle MERGE_PARTITIONING_HANDLE = new PartitioningHandle(Optional.empty(), Optional.empty(), (ConnectorPartitioningHandle)new MergePartitioningHandle(Optional.of(INSERT_PARTITIONING_SCHEME), Optional.empty()));

    @Override
    protected PlanTester createPlanTester() {
        Session session = TestingSession.testSessionBuilder().setCatalog("mock_merge_and_insert").setSchema("mock").setSystemProperty("task_scale_writers_enabled", "false").setSystemProperty("scale_writers", "false").build();
        PlanTester planTester = PlanTester.create((Session)session);
        planTester.createCatalog("mock_merge_and_insert", (ConnectorFactory)this.createMergeConnectorFactory(), (Map)ImmutableMap.of());
        return planTester;
    }

    private MockConnectorFactory createMergeConnectorFactory() {
        return MockConnectorFactory.builder().withGetTableHandle((session, schemaTableName) -> {
            if (schemaTableName.getTableName().equals("source_table")) {
                return new MockConnectorTableHandle((SchemaTableName)schemaTableName);
            }
            if (schemaTableName.getTableName().equals("target_table")) {
                return new MockConnectorTableHandle((SchemaTableName)schemaTableName);
            }
            return null;
        }).withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata("customer", (Type)IntegerType.INTEGER), (Object)new ColumnMetadata("year", (Type)IntegerType.INTEGER))).withGetInsertLayout((session, tableName) -> {
            if (tableName.getTableName().equals("source_table") || tableName.getTableName().equals("target_table")) {
                return Optional.of(new ConnectorTableLayout((List)ImmutableList.of((Object)"year")));
            }
            return Optional.empty();
        }).withName("mock_merge_and_insert").build();
    }

    @Test
    public void testTaskWriterCountHasNoEffectOnMergeOperation() {
        String query = "MERGE INTO target_table t USING source_table s\n    ON t.customer = s.customer\n    WHEN MATCHED\n        THEN DELETE\n";
        this.assertDistributedPlan(query, Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("task_max_writer_count", "1").setSystemProperty("task_min_writer_count", "8").build(), PlanMatchPattern.anyTree(PlanMatchPattern.mergeWriter(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, MERGE_PARTITIONING_HANDLE, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))))));
        this.assertDistributedPlan(query, Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("task_max_writer_count", "4").setSystemProperty("task_min_writer_count", "1").build(), PlanMatchPattern.anyTree(PlanMatchPattern.mergeWriter(PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, MERGE_PARTITIONING_HANDLE, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, MERGE_PARTITIONING_HANDLE, PlanMatchPattern.anyTree(PlanMatchPattern.node(TableScanNode.class, new PlanMatchPattern[0])))))));
    }

    @Test
    public void testTaskWriterCountHasNoEffectOnPartitionedInsertOperation() {
        String query = "INSERT INTO target_table SELECT * FROM source_table";
        this.assertDistributedPlan(query, Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("task_max_writer_count", "1").setSystemProperty("task_min_writer_count", "8").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.GATHER, SystemPartitioningHandle.SINGLE_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
        this.assertDistributedPlan(query, Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("task_max_writer_count", "4").setSystemProperty("task_min_writer_count", "1").build(), PlanMatchPattern.anyTree(PlanMatchPattern.tableWriter((List<String>)ImmutableList.of((Object)"customer", (Object)"year"), (List<String>)ImmutableList.of((Object)"customer", (Object)"year"), PlanMatchPattern.exchange(ExchangeNode.Scope.LOCAL, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.exchange(ExchangeNode.Scope.REMOTE, ExchangeNode.Type.REPARTITION, SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, PlanMatchPattern.tableScan("source_table", (Map<String, String>)ImmutableMap.of((Object)"customer", (Object)"customer", (Object)"year", (Object)"year")))))));
    }
}

