/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.cost.TaskCountEstimator;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.rule.DetermineTableScanNodePartitioning;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.AddExchanges;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.WindowNode;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestEliminateSorts
extends BasePlanTest {
    private static final String QUANTITY_ALIAS = "QUANTITY";
    private static final ExpectedValueProvider<DataOrganizationSpecification> windowSpec = PlanMatchPattern.specification((List<String>)ImmutableList.of(), (List<String>)ImmutableList.of((Object)"QUANTITY"), (Map<String, SortOrder>)ImmutableMap.of((Object)"QUANTITY", (Object)SortOrder.ASC_NULLS_LAST));
    private static final PlanMatchPattern LINEITEM_TABLESCAN_Q = PlanMatchPattern.tableScan("lineitem", (Map<String, String>)ImmutableMap.of((Object)"QUANTITY", (Object)"quantity"));

    @Test
    public void testNotEliminateSortsIfSortKeyIsDifferent() {
        String sql = "SELECT quantity, row_number() OVER (ORDER BY quantity) FROM lineitem ORDER BY tax";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort(PlanMatchPattern.anyTree(PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowSpec).addFunction(PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_Q)))));
        this.assertUnitPlan(sql, pattern);
    }

    @Test
    public void testNotEliminateSortsIfFilterExists() {
        String sql = "SELECT * FROM (\n    SELECT quantity, row_number() OVER (ORDER BY quantity)\n    FROM lineitem\n)\nWHERE quantity > 10\nORDER BY quantity\n";
        PlanMatchPattern pattern = PlanMatchPattern.anyTree(PlanMatchPattern.sort(PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference(QUANTITY_ALIAS), (Expression)new Cast((Expression)new LongLiteral(10L), (Type)DoubleType.DOUBLE)), PlanMatchPattern.window(windowMatcherBuilder -> windowMatcherBuilder.specification(windowSpec).addFunction(PlanMatchPattern.windowFunction("row_number", (List<String>)ImmutableList.of(), WindowNode.Frame.DEFAULT_FRAME)), PlanMatchPattern.anyTree(LINEITEM_TABLESCAN_Q))))));
        this.assertUnitPlan(sql, pattern);
    }

    private void assertUnitPlan(@Language(value="SQL") String sql, PlanMatchPattern pattern) {
        IrTypeAnalyzer typeAnalyzer = new IrTypeAnalyzer(this.getPlanTester().getPlannerContext());
        ImmutableList optimizers = ImmutableList.of((Object)new IterativeOptimizer(this.getPlanTester().getPlannerContext(), new RuleStatsRecorder(), this.getPlanTester().getStatsCalculator(), this.getPlanTester().getCostCalculator(), (Set)ImmutableSet.of((Object)new RemoveRedundantIdentityProjections(), (Object)new DetermineTableScanNodePartitioning(this.getPlanTester().getPlannerContext().getMetadata(), this.getPlanTester().getNodePartitioningManager(), new TaskCountEstimator(() -> 10)))), (Object)new AddExchanges(this.getPlanTester().getPlannerContext(), typeAnalyzer, this.getPlanTester().getStatsCalculator(), this.getPlanTester().getTaskCountEstimator()));
        this.assertPlan(sql, pattern, (List<PlanOptimizer>)optimizers);
    }
}

