/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.trino.SessionTestUtils;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.DecimalLiteral;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.LogicalExpression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.StringLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.optimizations.ExpressionEquivalence;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TestingTransactionManager;
import io.trino.transaction.TransactionManager;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExpressionEquivalence {
    private static final TestingTransactionManager TRANSACTION_MANAGER = new TestingTransactionManager();
    private static final PlannerContext PLANNER_CONTEXT = TestingPlannerContext.plannerContextBuilder().withTransactionManager(TRANSACTION_MANAGER).build();
    private static final ExpressionEquivalence EQUIVALENCE = new ExpressionEquivalence(PLANNER_CONTEXT.getMetadata(), PLANNER_CONTEXT.getFunctionManager(), PLANNER_CONTEXT.getTypeManager(), new IrTypeAnalyzer(PLANNER_CONTEXT));
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction MOD = FUNCTIONS.resolveFunction("mod", TypeSignatureProvider.fromTypes((Type[])new Type[]{IntegerType.INTEGER, IntegerType.INTEGER}));

    @Test
    public void testEquivalent() {
        TestExpressionEquivalence.assertEquivalent((Expression)new Cast((Expression)new NullLiteral(), (Type)BigintType.BIGINT), (Expression)new Cast((Expression)new NullLiteral(), (Type)BigintType.BIGINT));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_double")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b_double"), (Expression)new SymbolReference("a_bigint")));
        TestExpressionEquivalence.assertEquivalent((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.TRUE_LITERAL);
        TestExpressionEquivalence.assertEquivalent((Expression)new LongLiteral(4L), (Expression)new LongLiteral(4L));
        TestExpressionEquivalence.assertEquivalent((Expression)new DecimalLiteral("4.4"), (Expression)new DecimalLiteral("4.4"));
        TestExpressionEquivalence.assertEquivalent((Expression)new StringLiteral("foo"), (Expression)new StringLiteral("foo"));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new DecimalLiteral("4.4"), (Expression)new DecimalLiteral("5.5")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new DecimalLiteral("5.5"), (Expression)new DecimalLiteral("4.4")));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new StringLiteral("foo"), (Expression)new StringLiteral("bar")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new StringLiteral("bar"), (Expression)new StringLiteral("foo")));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-05-10 12:34:56.123456789"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2021-05-10 12:34:56.123456789")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2021-05-10 12:34:56.123456789"), (Expression)new GenericLiteral((Type)TimestampType.createTimestampType((int)9), "2020-05-10 12:34:56.123456789")));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "2020-05-10 12:34:56.123456789 +8"), (Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "2021-05-10 12:34:56.123456789 +8")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "2021-05-10 12:34:56.123456789 +8"), (Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "2020-05-10 12:34:56.123456789 +8")));
        TestExpressionEquivalence.assertEquivalent((Expression)new FunctionCall(MOD.toQualifiedName(), (List)ImmutableList.of((Object)new LongLiteral(4L), (Object)new LongLiteral(5L))), (Expression)new FunctionCall(MOD.toQualifiedName(), (List)ImmutableList.of((Object)new LongLiteral(4L), (Object)new LongLiteral(5L))));
        TestExpressionEquivalence.assertEquivalent((Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("a_bigint"));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_bigint")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("b_bigint"), (Expression)new SymbolReference("a_bigint")));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_bigint")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b_bigint"), (Expression)new SymbolReference("a_bigint")));
        TestExpressionEquivalence.assertEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_double")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b_double"), (Expression)new SymbolReference("a_bigint")));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.TRUE_LITERAL, (Object)BooleanLiteral.FALSE_LITERAL)), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)BooleanLiteral.FALSE_LITERAL, (Object)BooleanLiteral.TRUE_LITERAL)));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(6L), (Expression)new LongLiteral(7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(7L), (Expression)new LongLiteral(6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(6L), (Expression)new LongLiteral(7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(7L), (Expression)new LongLiteral(6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("c_bigint"), (Expression)new SymbolReference("d_bigint")))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("d_bigint"), (Expression)new SymbolReference("c_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("b_bigint"), (Expression)new SymbolReference("a_bigint")))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("c_bigint"), (Expression)new SymbolReference("d_bigint")))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("d_bigint"), (Expression)new SymbolReference("c_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("b_bigint"), (Expression)new SymbolReference("a_bigint")))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(6L), (Expression)new LongLiteral(7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(7L), (Expression)new LongLiteral(6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(2L), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(6L), (Expression)new LongLiteral(7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(7L), (Expression)new LongLiteral(6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(3L), (Expression)new LongLiteral(2L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)))), (Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(6L), (Expression)new LongLiteral(7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(7L), (Expression)new LongLiteral(6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(2L), (Expression)new LongLiteral(3L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(6L), (Expression)new LongLiteral(7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(7L), (Expression)new LongLiteral(6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(4L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(3L), (Expression)new LongLiteral(2L)))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a_boolean"), (Object)new SymbolReference("b_boolean"), (Object)new SymbolReference("c_boolean"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("c_boolean"), (Object)new SymbolReference("b_boolean"), (Object)new SymbolReference("a_boolean"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a_boolean"), (Object)new SymbolReference("b_boolean"))), (Object)new SymbolReference("c_boolean"))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("c_boolean"), (Object)new SymbolReference("b_boolean"))), (Object)new SymbolReference("a_boolean"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a_boolean"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("b_boolean"), (Object)new SymbolReference("c_boolean"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a_boolean"), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("c_boolean"), (Object)new SymbolReference("b_boolean"))), (Object)new SymbolReference("a_boolean"))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("a_boolean"), (Object)new SymbolReference("b_boolean"), (Object)new SymbolReference("c_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("d_boolean"), (Object)new SymbolReference("e_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("f_boolean"), (Object)new SymbolReference("g_boolean"), (Object)new SymbolReference("h_boolean"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("h_boolean"), (Object)new SymbolReference("g_boolean"), (Object)new SymbolReference("f_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("b_boolean"), (Object)new SymbolReference("a_boolean"), (Object)new SymbolReference("c_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new SymbolReference("e_boolean"), (Object)new SymbolReference("d_boolean"))))));
        TestExpressionEquivalence.assertEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("a_boolean"), (Object)new SymbolReference("b_boolean"), (Object)new SymbolReference("c_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("d_boolean"), (Object)new SymbolReference("e_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("f_boolean"), (Object)new SymbolReference("g_boolean"), (Object)new SymbolReference("h_boolean"))))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("h_boolean"), (Object)new SymbolReference("g_boolean"), (Object)new SymbolReference("f_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("b_boolean"), (Object)new SymbolReference("a_boolean"), (Object)new SymbolReference("c_boolean"))), (Object)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new SymbolReference("e_boolean"), (Object)new SymbolReference("d_boolean"))))));
    }

    private static void assertEquivalent(Expression leftExpression, Expression rightExpression) {
        Set symbols = SymbolsExtractor.extractUnique((Iterable)ImmutableList.of((Object)leftExpression, (Object)rightExpression));
        TypeProvider types = TypeProvider.copyOf(symbols.stream().collect(Collectors.toMap(Function.identity(), TestExpressionEquivalence::generateType)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(leftExpression, rightExpression, types)).describedAs(String.format("Expected (%s) and (%s) to be equivalent", leftExpression, rightExpression), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(rightExpression, leftExpression, types)).describedAs(String.format("Expected (%s) and (%s) to be equivalent", rightExpression, leftExpression), new Object[0])).isTrue();
    }

    @Test
    public void testNotEquivalent() {
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN), (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionEquivalence.assertNotEquivalent((Expression)BooleanLiteral.FALSE_LITERAL, (Expression)new Cast((Expression)new NullLiteral(), (Type)BooleanType.BOOLEAN));
        TestExpressionEquivalence.assertNotEquivalent((Expression)BooleanLiteral.TRUE_LITERAL, (Expression)BooleanLiteral.FALSE_LITERAL);
        TestExpressionEquivalence.assertNotEquivalent((Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new DecimalLiteral("4.4"), (Expression)new DecimalLiteral("5.5"));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new StringLiteral("'foo'"), (Expression)new StringLiteral("'bar'"));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.NOT_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(6L)));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new FunctionCall(MOD.toQualifiedName(), (List)ImmutableList.of((Object)new LongLiteral(4L), (Object)new LongLiteral(5L))), (Expression)new FunctionCall(MOD.toQualifiedName(), (List)ImmutableList.of((Object)new LongLiteral(5L), (Object)new LongLiteral(4L))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_bigint"));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_bigint")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)new SymbolReference("b_bigint"), (Expression)new SymbolReference("c_bigint")));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_bigint")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b_bigint"), (Expression)new SymbolReference("c_bigint")));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_double")), (Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("b_double"), (Expression)new SymbolReference("c_bigint")));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(6L), (Expression)new LongLiteral(7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(7L), (Expression)new LongLiteral(6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(6L)))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new LongLiteral(4L), (Expression)new LongLiteral(5L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new LongLiteral(6L), (Expression)new LongLiteral(7L)))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new LongLiteral(7L), (Expression)new LongLiteral(6L)), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new LongLiteral(5L), (Expression)new LongLiteral(6L)))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("c_bigint"), (Expression)new SymbolReference("d_bigint")))), (Expression)new LogicalExpression(LogicalExpression.Operator.AND, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("d_bigint"), (Expression)new SymbolReference("c_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("b_bigint"), (Expression)new SymbolReference("c_bigint")))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN_OR_EQUAL, (Expression)new SymbolReference("a_bigint"), (Expression)new SymbolReference("b_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.LESS_THAN, (Expression)new SymbolReference("c_bigint"), (Expression)new SymbolReference("d_bigint")))), (Expression)new LogicalExpression(LogicalExpression.Operator.OR, (List)ImmutableList.of((Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("d_bigint"), (Expression)new SymbolReference("c_bigint")), (Object)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL, (Expression)new SymbolReference("b_bigint"), (Expression)new SymbolReference("c_bigint")))));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new GenericLiteral((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)3), "12:34:56.123 +00:00"), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new GenericLiteral((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)3), "14:34:56.123 +02:00"), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new GenericLiteral((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)6), "12:34:56.123456 +00:00"), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new GenericLiteral((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)6), "14:34:56.123456 +02:00"), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new GenericLiteral((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9), "12:34:56.123456789 +00:00"), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new GenericLiteral((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)9), "14:34:56.123456789 +02:00"), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new GenericLiteral((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)12), "12:34:56.123456789012 +00:00"), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new GenericLiteral((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)12), "14:34:56.123456789012 +02:00"), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "2020-05-10 12:34:56.123 Europe/Warsaw"), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3), "2020-05-10 12:34:56.123 Europe/Paris"), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), "2020-05-10 12:34:56.123456 Europe/Warsaw"), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6), "2020-05-10 12:34:56.123456 Europe/Paris"), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "2020-05-10 12:34:56.123456789 Europe/Warsaw"), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)9), "2020-05-10 12:34:56.123456789 Europe/Paris"), (Type)VarcharType.VARCHAR));
        TestExpressionEquivalence.assertNotEquivalent((Expression)new Cast((Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), "2020-05-10 12:34:56.123456789012 Europe/Warsaw"), (Type)VarcharType.VARCHAR), (Expression)new Cast((Expression)new GenericLiteral((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12), "2020-05-10 12:34:56.123456789012 Europe/Paris"), (Type)VarcharType.VARCHAR));
    }

    private static void assertNotEquivalent(Expression leftExpression, Expression rightExpression) {
        Set symbols = SymbolsExtractor.extractUnique((Iterable)ImmutableList.of((Object)leftExpression, (Object)rightExpression));
        TypeProvider types = TypeProvider.copyOf(symbols.stream().collect(Collectors.toMap(Function.identity(), TestExpressionEquivalence::generateType)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(leftExpression, rightExpression, types)).describedAs(String.format("Expected (%s) and (%s) to not be equivalent", leftExpression, rightExpression), new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)TestExpressionEquivalence.areExpressionEquivalent(rightExpression, leftExpression, types)).describedAs(String.format("Expected (%s) and (%s) to not be equivalent", rightExpression, leftExpression), new Object[0])).isFalse();
    }

    private static boolean areExpressionEquivalent(Expression leftExpression, Expression rightExpression, TypeProvider types) {
        TestingTransactionManager transactionManager = new TestingTransactionManager();
        MetadataManager metadata = MetadataManager.testMetadataManagerBuilder().withTransactionManager((TransactionManager)transactionManager).build();
        return (Boolean)TransactionBuilder.transaction((TransactionManager)transactionManager, (Metadata)metadata, (AccessControl)new AllowAllAccessControl()).singleStatement().execute(SessionTestUtils.TEST_SESSION, transactionSession -> EQUIVALENCE.areExpressionsEquivalent(transactionSession, leftExpression, rightExpression, types));
    }

    private static Type generateType(Symbol symbol) {
        String typeName = (String)Splitter.on((char)'_').limit(2).splitToList((CharSequence)symbol.getName()).get(1);
        return PLANNER_CONTEXT.getTypeManager().getType(new TypeSignature(typeName, (List)ImmutableList.of()));
    }
}

