/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.ArithmeticUnaryExpression;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.FunctionCall;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IfExpression;
import io.trino.sql.ir.NullLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.ClassifierValuePointer;
import io.trino.sql.planner.rowpattern.ExpressionAndValuePointers;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrConcatenation;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPatternRecognitionNodeSerialization {
    @Test
    public void testScalarValuePointerRoundtrip() {
        JsonCodec codec = new JsonCodecFactory((Provider)new ObjectMapperProvider()).jsonCodec(ValuePointer.class);
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), false, false, 5, 5), new Symbol("input_symbol")));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), true, true, 1, -1), new Symbol("input_symbol")));
    }

    @Test
    public void testAggregationValuePointerRoundtrip() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setKeyDeserializers((Map)ImmutableMap.of(TypeSignature.class, (Object)new TypeSignatureKeyDeserializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer((TypeManager)new TestingTypeManager())));
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec(ValuePointer.class);
        ResolvedFunction countFunction = MetadataManager.createTestMetadataManager().resolveBuiltinFunction("count", (List)ImmutableList.of());
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new AggregationValuePointer(countFunction, new AggregatedSetDescriptor((Set)ImmutableSet.of(), false), (List)ImmutableList.of(), Optional.of(new Symbol("classifier")), Optional.of(new Symbol("match_number"))));
        ResolvedFunction maxFunction = MetadataManager.createTestMetadataManager().resolveBuiltinFunction("max", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new AggregationValuePointer(maxFunction, new AggregatedSetDescriptor((Set)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), true), (List)ImmutableList.of((Object)new NullLiteral()), Optional.of(new Symbol("classifier")), Optional.of(new Symbol("match_number"))));
    }

    @Test
    public void testExpressionAndValuePointersRoundtrip() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec(ExpressionAndValuePointers.class);
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of()));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new ExpressionAndValuePointers((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("classifier"), (Expression)new SymbolReference("x")), (Expression)new FunctionCall("rand", (List)ImmutableList.of()), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("match_number"))), (List)ImmutableList.of((Object)new ExpressionAndValuePointers.Assignment(new Symbol("classifier"), (ValuePointer)new ClassifierValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("A"), (Object)new IrLabel("B")), false, true, 1, -1))), (Object)new ExpressionAndValuePointers.Assignment(new Symbol("x"), (ValuePointer)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("B")), true, false, 2, 1), new Symbol("input_symbol_a"))), (Object)new ExpressionAndValuePointers.Assignment(new Symbol("match_number"), (ValuePointer)new MatchNumberValuePointer()))));
    }

    @Test
    public void testMeasureRoundtrip() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer((TypeManager)new TestingTypeManager())));
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec(PatternRecognitionNode.Measure.class);
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new PatternRecognitionNode.Measure(new ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of()), (Type)BooleanType.BOOLEAN));
        TestPatternRecognitionNodeSerialization.assertJsonRoundTrip(codec, new PatternRecognitionNode.Measure(new ExpressionAndValuePointers((Expression)new IfExpression((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("match_number"), (Expression)new SymbolReference("x")), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "10"), (Expression)new ArithmeticUnaryExpression(ArithmeticUnaryExpression.Sign.MINUS, (Expression)new SymbolReference("y"))), (List)ImmutableList.of((Object)new ExpressionAndValuePointers.Assignment(new Symbol("match_number"), (ValuePointer)new MatchNumberValuePointer()), (Object)new ExpressionAndValuePointers.Assignment(new Symbol("x"), (ValuePointer)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of(), true, true, 0, 0), new Symbol("input_symbol_a"))), (Object)new ExpressionAndValuePointers.Assignment(new Symbol("y"), (ValuePointer)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("B")), false, true, 1, -1), new Symbol("input_symbol_b"))))), (Type)BigintType.BIGINT));
    }

    @Test
    public void testPatternRecognitionNodeRoundtrip() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setKeyDeserializers((Map)ImmutableMap.of(TypeSignature.class, (Object)new TypeSignatureKeyDeserializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer((TypeManager)new TestingTypeManager())));
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec(PatternRecognitionNode.class);
        ResolvedFunction rankFunction = MetadataManager.createTestMetadataManager().resolveBuiltinFunction("rank", (List)ImmutableList.of());
        PatternRecognitionNode node = new PatternRecognitionNode(new PlanNodeId("0"), (PlanNode)new ValuesNode(new PlanNodeId("1"), 1), new DataOrganizationSpecification((List)ImmutableList.of(), Optional.empty()), Optional.empty(), (Set)ImmutableSet.of(), 0, (Map)ImmutableMap.of((Object)new Symbol("rank"), (Object)new WindowNode.Function(rankFunction, (List)ImmutableList.of(), new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty()), false)), (Map)ImmutableMap.of((Object)new Symbol("measure"), (Object)new PatternRecognitionNode.Measure(new ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of()), (Type)BooleanType.BOOLEAN)), Optional.of(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())), RowsPerMatch.WINDOW, (Set)ImmutableSet.of((Object)new IrLabel("B")), SkipToPosition.LAST, true, (IrRowPattern)new IrConcatenation((List)ImmutableList.of((Object)new IrLabel("A"), (Object)new IrLabel("B"), (Object)new IrLabel("C"))), (Map)ImmutableMap.of((Object)new IrLabel("B"), (Object)new ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of()), (Object)new IrLabel("C"), (Object)new ExpressionAndValuePointers((Expression)new NullLiteral(), (List)ImmutableList.of())));
        PatternRecognitionNode roundtripNode = (PatternRecognitionNode)codec.fromJson(codec.toJson((Object)node));
        Assertions.assertThat((Map)roundtripNode.getMeasures()).isEqualTo((Object)node.getMeasures());
        Assertions.assertThat((Comparable)roundtripNode.getRowsPerMatch()).isEqualTo((Object)node.getRowsPerMatch());
        Assertions.assertThat((Collection)roundtripNode.getSkipToLabels()).isEqualTo((Object)node.getSkipToLabels());
        Assertions.assertThat((Comparable)roundtripNode.getSkipToPosition()).isEqualTo((Object)node.getSkipToPosition());
        Assertions.assertThat((boolean)roundtripNode.isInitial()).isEqualTo(node.isInitial());
        Assertions.assertThat((Object)roundtripNode.getPattern()).isEqualTo((Object)node.getPattern());
        Assertions.assertThat((Map)roundtripNode.getVariableDefinitions()).isEqualTo((Object)node.getVariableDefinitions());
    }

    public static <T> void assertJsonRoundTrip(JsonCodec<T> codec, T object) {
        String json = codec.toJson(object);
        Object copy = codec.fromJson(json);
        Assertions.assertThat((Object)copy).isEqualTo(object);
    }
}

