/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.plan.DataOrganizationSpecification;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestWindowNode {
    private final TestingFunctionResolution functionResolution = new TestingFunctionResolution();
    private final ObjectMapper objectMapper;

    public TestWindowNode() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setKeyDeserializers((Map)ImmutableMap.of(TypeSignature.class, (Object)new TypeSignatureKeyDeserializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(arg_0 -> ((TestingTypeManager)new TestingTypeManager()).getType(arg_0))));
        this.objectMapper = provider.get();
    }

    @Test
    public void testSerializationRoundtrip() throws Exception {
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol columnA = symbolAllocator.newSymbol("a", (Type)BigintType.BIGINT);
        Symbol columnB = symbolAllocator.newSymbol("b", (Type)BigintType.BIGINT);
        Symbol columnC = symbolAllocator.newSymbol("c", (Type)BigintType.BIGINT);
        ValuesNode sourceNode = new ValuesNode(TestWindowNode.newId(), (List)ImmutableList.of((Object)columnA, (Object)columnB, (Object)columnC), (List)ImmutableList.of());
        Symbol windowSymbol = symbolAllocator.newSymbol("sum", (Type)BigintType.BIGINT);
        ResolvedFunction resolvedFunction = this.functionResolution.resolveFunction("sum", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        WindowNode.Frame frame = new WindowNode.Frame(WindowFrameType.RANGE, FrameBoundType.UNBOUNDED_PRECEDING, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty());
        PlanNodeId id = TestWindowNode.newId();
        DataOrganizationSpecification specification = new DataOrganizationSpecification((List)ImmutableList.of((Object)columnA), Optional.of(new OrderingScheme((List)ImmutableList.of((Object)columnB), (Map)ImmutableMap.of((Object)columnB, (Object)SortOrder.ASC_NULLS_FIRST))));
        ImmutableMap functions = ImmutableMap.of((Object)windowSymbol, (Object)new WindowNode.Function(resolvedFunction, (List)ImmutableList.of((Object)columnC.toSymbolReference()), frame, false));
        Optional<Symbol> hashSymbol = Optional.of(columnB);
        ImmutableSet prePartitionedInputs = ImmutableSet.of((Object)columnA);
        WindowNode windowNode = new WindowNode(id, (PlanNode)sourceNode, specification, (Map)functions, hashSymbol, (Set)prePartitionedInputs, 0);
        String json = this.objectMapper.writeValueAsString((Object)windowNode);
        WindowNode actualNode = (WindowNode)this.objectMapper.readValue(json, WindowNode.class);
        Assertions.assertThat((Object)actualNode.getId()).isEqualTo((Object)windowNode.getId());
        Assertions.assertThat((Object)actualNode.getSpecification()).isEqualTo((Object)windowNode.getSpecification());
        Assertions.assertThat((Map)actualNode.getWindowFunctions()).isEqualTo((Object)windowNode.getWindowFunctions());
        Assertions.assertThat((List)actualNode.getFrames()).isEqualTo((Object)windowNode.getFrames());
        Assertions.assertThat((Optional)actualNode.getHashSymbol()).isEqualTo((Object)windowNode.getHashSymbol());
        Assertions.assertThat((Collection)actualNode.getPrePartitionedInputs()).isEqualTo((Object)windowNode.getPrePartitionedInputs());
        Assertions.assertThat((int)actualNode.getPreSortedOrderPrefix()).isEqualTo(windowNode.getPreSortedOrderPrefix());
    }

    private static PlanNodeId newId() {
        return new PlanNodeId(UUID.randomUUID().toString());
    }
}

