/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.sanity;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.SessionTestUtils;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.plugin.tpch.TpchTableHandle;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.DynamicFilters;
import io.trino.sql.PlannerContext;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.ComparisonExpression;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.GenericLiteral;
import io.trino.sql.ir.IrUtils;
import io.trino.sql.ir.IsNotNullPredicate;
import io.trino.sql.ir.IsNullPredicate;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.IrTypeAnalyzer;
import io.trino.sql.planner.PlanNodeIdAllocator;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.sanity.DynamicFiltersChecker;
import io.trino.testing.TestingTransactionHandle;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestDynamicFiltersChecker
extends BasePlanTest {
    private Metadata metadata;
    private PlanBuilder builder;
    private Symbol lineitemOrderKeySymbol;
    private TableScanNode lineitemTableScanNode;
    private Symbol ordersOrderKeySymbol;
    private TableScanNode ordersTableScanNode;
    private PlannerContext plannerContext;

    @BeforeAll
    public void setup() {
        this.plannerContext = this.getPlanTester().getPlannerContext();
        this.metadata = this.plannerContext.getMetadata();
        this.builder = new PlanBuilder(new PlanNodeIdAllocator(), this.plannerContext, SessionTestUtils.TEST_SESSION);
        CatalogHandle catalogHandle = this.getCurrentCatalogHandle();
        TableHandle lineitemTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)new TpchTableHandle("sf1", "lineitem", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        this.lineitemOrderKeySymbol = this.builder.symbol("LINEITEM_OK", (Type)BigintType.BIGINT);
        this.lineitemTableScanNode = this.builder.tableScan(lineitemTableHandle, (List<Symbol>)ImmutableList.of((Object)this.lineitemOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.lineitemOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
        TableHandle ordersTableHandle = new TableHandle(catalogHandle, (ConnectorTableHandle)new TpchTableHandle("sf1", "orders", 1.0), (ConnectorTransactionHandle)TestingTransactionHandle.create());
        this.ordersOrderKeySymbol = this.builder.symbol("ORDERS_OK", (Type)BigintType.BIGINT);
        this.ordersTableScanNode = this.builder.tableScan(ordersTableHandle, (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)this.ordersOrderKeySymbol, (Object)new TpchColumnHandle("orderkey", (Type)BigintType.BIGINT)));
    }

    @Test
    public void testUnconsumedDynamicFilterInJoin() {
        JoinNode root = this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("ORDERS_OK"), (Expression)new LongLiteral(0L)), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.lineitemOrderKeySymbol));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testUnconsumedDynamicFilterInJoin$0((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessageMatching("Dynamic filters \\[DF\\] present in join were not fully consumed by it's probe side.");
    }

    @Test
    public void testDynamicFilterConsumedOnBuildSide() {
        JoinNode root = this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference()), (PlanNode)this.ordersTableScanNode), (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference()), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.lineitemOrderKeySymbol));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testDynamicFilterConsumedOnBuildSide$1((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessageMatching("Dynamic filters \\[DF\\] present in join were consumed by it's build side.");
    }

    @Test
    public void testUnmatchedDynamicFilter() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(IrUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("LINEITEM_OK"), (Expression)new LongLiteral(0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testUnmatchedDynamicFilter$2((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessageMatching("All consumed dynamic filters could not be matched with a join/semi-join.");
    }

    @Test
    public void testDynamicFilterNotAboveTableScan() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(IrUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("LINEITEM_OK"), (Expression)new LongLiteral(0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.builder.values(this.lineitemOrderKeySymbol)), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.lineitemOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testDynamicFilterNotAboveTableScan$3((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessageMatching("Dynamic filters \\[Descriptor\\{id=DF, input=ORDERS_OK, operator=EQUAL, nullAllowed=false\\}\\] present in filter predicate whose source is not a table scan.");
    }

    @Test
    public void testUnmatchedNestedDynamicFilter() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.ordersTableScanNode, (PlanNode)this.builder.filter(IrUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{IrUtils.combineDisjuncts((Metadata)this.metadata, (Expression[])new Expression[]{new IsNullPredicate((Expression)new SymbolReference("LINEITEM_OK")), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), IrUtils.combineDisjuncts((Metadata)this.metadata, (Expression[])new Expression[]{new IsNotNullPredicate((Expression)new SymbolReference("LINEITEM_OK")), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())})}), (PlanNode)this.lineitemTableScanNode), (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), (List<Symbol>)ImmutableList.of(), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testUnmatchedNestedDynamicFilter$4((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessageMatching("All consumed dynamic filters could not be matched with a join/semi-join.");
    }

    @Test
    public void testUnsupportedDynamicFilterExpression() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.ADD, (Expression)new SymbolReference("LINEITEM_OK"), (Expression)new GenericLiteral((Type)BigintType.BIGINT, "1"))), (PlanNode)this.lineitemTableScanNode), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.lineitemOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.lineitemOrderKeySymbol), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testUnsupportedDynamicFilterExpression$5((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessageMatching("Dynamic filter expression \\+\\(LINEITEM_OK, Literal\\[bigint, 1]\\) must be a SymbolReference or a CAST of SymbolReference.");
    }

    @Test
    public void testUnsupportedCastExpression() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.join(JoinType.INNER, (PlanNode)this.builder.filter(DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)new Cast((Expression)new Cast((Expression)new SymbolReference("LINEITEM_OK"), (Type)IntegerType.INTEGER), (Type)BigintType.BIGINT)), (PlanNode)this.lineitemTableScanNode), (PlanNode)this.ordersTableScanNode, (List<JoinNode.EquiJoinClause>)ImmutableList.of((Object)new JoinNode.EquiJoinClause(this.lineitemOrderKeySymbol, this.ordersOrderKeySymbol)), (List<Symbol>)ImmutableList.of((Object)this.lineitemOrderKeySymbol), (List<Symbol>)ImmutableList.of((Object)this.ordersOrderKeySymbol), Optional.empty(), Optional.empty(), Optional.empty(), (Map<DynamicFilterId, Symbol>)ImmutableMap.of((Object)new DynamicFilterId("DF"), (Object)this.ordersOrderKeySymbol)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testUnsupportedCastExpression$6((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessageMatching("The expression CAST\\(LINEITEM_OK AS integer\\) within in a CAST in dynamic filter must be a SymbolReference.");
    }

    @Test
    public void testUnconsumedDynamicFilterInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter((Expression)new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("ORDERS_OK"), (Expression)new LongLiteral(0L)), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testUnconsumedDynamicFilterInSemiJoin$7((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessage("The dynamic filter DF present in semi-join was not consumed by it's source side.");
    }

    @Test
    public void testDynamicFilterConsumedOnFilteringSourceSideInSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(IrUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("ORDERS_OK"), (Expression)new LongLiteral(0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.ordersTableScanNode), (PlanNode)this.builder.filter(IrUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("LINEITEM_OK"), (Expression)new LongLiteral(0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.lineitemOrderKeySymbol.toSymbolReference())}), (PlanNode)this.lineitemTableScanNode), this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testDynamicFilterConsumedOnFilteringSourceSideInSemiJoin$8((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessage("The dynamic filter DF present in semi-join was consumed by it's filtering source side.");
    }

    @Test
    public void testUnmatchedDynamicFilterInSemiJoin() {
        OutputNode root = this.builder.output((List<String>)ImmutableList.of(), (List<Symbol>)ImmutableList.of(), (PlanNode)this.builder.semiJoin((PlanNode)this.builder.filter(IrUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("ORDERS_OK"), (Expression)new LongLiteral(0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.ordersTableScanNode), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testUnmatchedDynamicFilterInSemiJoin$9((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessage("All consumed dynamic filters could not be matched with a join/semi-join.");
    }

    @Test
    public void testDynamicFilterNotAboveTableScanWithSemiJoin() {
        SemiJoinNode root = this.builder.semiJoin((PlanNode)this.builder.filter(IrUtils.combineConjuncts((Metadata)this.metadata, (Expression[])new Expression[]{new ComparisonExpression(ComparisonExpression.Operator.GREATER_THAN, (Expression)new SymbolReference("ORDERS_OK"), (Expression)new LongLiteral(0L)), DynamicFilters.createDynamicFilterExpression((Metadata)this.metadata, (DynamicFilterId)new DynamicFilterId("DF"), (Type)BigintType.BIGINT, (Expression)this.ordersOrderKeySymbol.toSymbolReference())}), (PlanNode)this.builder.values(this.ordersOrderKeySymbol)), (PlanNode)this.lineitemTableScanNode, this.ordersOrderKeySymbol, this.lineitemOrderKeySymbol, new Symbol("SEMIJOIN_OUTPUT"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(new DynamicFilterId("DF")));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testDynamicFilterNotAboveTableScanWithSemiJoin$10((PlanNode)root)).isInstanceOf(VerifyException.class)).hasMessageMatching("Dynamic filters \\[Descriptor\\{id=DF, input=ORDERS_OK, operator=EQUAL, nullAllowed=false\\}\\] present in filter predicate whose source is not a table scan.");
    }

    private void validatePlan(PlanNode root) {
        this.getPlanTester().inTransaction(session -> {
            session.getCatalog().ifPresent(catalog -> this.metadata.getCatalogHandle(session, catalog));
            new DynamicFiltersChecker().validate(root, session, this.plannerContext, new IrTypeAnalyzer(this.plannerContext), TypeProvider.empty(), WarningCollector.NOOP);
            return null;
        });
    }

    private /* synthetic */ void lambda$testDynamicFilterNotAboveTableScanWithSemiJoin$10(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testUnmatchedDynamicFilterInSemiJoin$9(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testDynamicFilterConsumedOnFilteringSourceSideInSemiJoin$8(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testUnconsumedDynamicFilterInSemiJoin$7(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testUnsupportedCastExpression$6(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testUnsupportedDynamicFilterExpression$5(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testUnmatchedNestedDynamicFilter$4(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testDynamicFilterNotAboveTableScan$3(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testUnmatchedDynamicFilter$2(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testDynamicFilterConsumedOnBuildSide$1(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }

    private /* synthetic */ void lambda$testUnconsumedDynamicFilterInJoin$0(PlanNode root) throws Throwable {
        this.validatePlan(root);
    }
}

