/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestCopyAggregationStateInRowPatternMatching {
    private static final String QUERY = "SELECT m.id, m.classy\nFROM (VALUES (1), (2), (3)) t(id)\n   MATCH_RECOGNIZE (\n     ORDER BY id\n     MEASURES CLASSIFIER() AS classy\n     ALL ROWS PER MATCH\n     PATTERN ((A | B)* X)\n     %s\n  ) AS m\n";
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testArrayAgg() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(array_agg(CLASSIFIER()), '', '') = 'BAX' ")))).matches("VALUES\n     (1, VARCHAR 'B'),\n     (2, 'A'),\n     (3, 'X')\n");
    }

    @Test
    public void testMinByN() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(min_by(CLASSIFIER(), id, 3), '', '') = 'BAX' ")))).matches("VALUES\n     (1, VARCHAR 'B'),\n     (2, 'A'),\n     (3, 'X')\n");
    }

    @Test
    public void testMaxByN() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(max_by(CLASSIFIER(), id, 3), '', '') = 'XAB' ")))).matches("VALUES\n     (1, VARCHAR 'B'),\n     (2, 'A'),\n     (3, 'X')\n");
    }

    @Test
    public void testMinN() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(min(CLASSIFIER(), 3), '', '') = 'ABX' ")))).matches("VALUES\n     (1, VARCHAR 'A'),\n     (2, 'B'),\n     (3, 'X')\n");
    }

    @Test
    public void testMaxN() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(max(CLASSIFIER(), 3), '', '') = 'XBA' ")))).matches("VALUES\n     (1, VARCHAR 'A'),\n     (2, 'B'),\n     (3, 'X')\n");
    }

    @Test
    public void testMultimapAgg() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS array_join(element_at(multimap_agg(id, CLASSIFIER()), 1), '', '') = 'B' ")))).matches("VALUES\n     (1, VARCHAR 'B'),\n     (2, 'A'),\n     (3, 'X')\n");
    }

    @Test
    public void testMapAgg() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS element_at(map_agg(id, CLASSIFIER()), 1) = 'B' ")))).matches("VALUES\n     (1, VARCHAR 'B'),\n     (2, 'A'),\n     (3, 'X')\n");
    }

    @Test
    public void testMapUnion() {
        String query = "SELECT m.id, m.classy\nFROM (VALUES ('B'), ('C'), ('D')) t(id)\n   MATCH_RECOGNIZE (\n     ORDER BY id\n     MEASURES CLASSIFIER() AS classy\n     ALL ROWS PER MATCH\n     PATTERN ((A | B)* X)\n     %s\n  ) AS m\n";
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(query, "DEFINE X AS element_at(map_union(MAP(ARRAY[id], ARRAY[id])), 'B') = FIRST(CLASSIFIER()) ")))).matches("VALUES\n     ('B', VARCHAR 'B'),\n     ('C', 'A'),\n     ('D', 'X')\n");
    }

    @Test
    public void testDecimalAvg() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS avg(CAST(B.id AS decimal(2, 1))) = 1e0 ")))).matches("VALUES\n     (1, VARCHAR 'B'),\n     (2, 'A'),\n     (3, 'X')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS avg(CAST(B.id AS decimal(30, 20))) = 1e0 ")))).matches("VALUES\n     (1, VARCHAR 'B'),\n     (2, 'A'),\n     (3, 'X')\n");
    }

    @Test
    public void testDecimalSum() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS sum(CAST(B.id AS decimal(2, 1))) = 1.0 ")))).matches("VALUES\n     (1, VARCHAR 'B'),\n     (2, 'A'),\n     (3, 'X')\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format(QUERY, "DEFINE X AS sum(CAST(B.id AS decimal(30, 20))) = 1.0 ")))).matches("VALUES\n     (1, VARCHAR 'B'),\n     (2, 'A'),\n     (3, 'X')\n");
    }
}

