/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.ir.ArithmeticBinaryExpression;
import io.trino.sql.ir.BooleanLiteral;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.LongLiteral;
import io.trino.sql.ir.SymbolReference;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestSubqueries {
    private static final String UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG = "line .*: Given correlated subquery is not supported";
    private final QueryAssertions assertions;

    public TestSubqueries() {
        Session session = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").build();
        StandaloneQueryRunner runner = new StandaloneQueryRunner(session);
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog("test_catalog", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        this.assertions = new QueryAssertions((QueryRunner)runner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testCorrelatedExistsSubqueriesWithOrPredicateAndNull() {
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT 1 FROM (VALUES null, 10) t(x) WHERE y > x OR y + 10 > x) FROM (values 11 + if(rand() >= 0, 0)) t2(y)", "VALUES true", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), aggregation -> aggregation.isStreamable() && aggregation.getStep() == AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("y")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"NON_NULL", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.values("x"))))));
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT 1 FROM (VALUES null) t(x) WHERE y > x OR y + 10 > x) FROM (VALUES 11 + if(rand() >= 0, 0)) t2(y)", "VALUES false", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), aggregation -> aggregation.isStreamable() && aggregation.getStep() == AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("y")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"NON_NULL", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.values("x"))))));
    }

    @Test
    public void testSubqueriesWithGroupByAndCoercions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT EXISTS(SELECT 1 FROM (VALUES (1, null)) t(a, b) WHERE t.a=t2.b GROUP BY t.b) FROM (VALUES 1.0, 2.0) t2(b)"))).matches("VALUES true, false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT EXISTS(SELECT 1 FROM (VALUES (null, null)) t(a, b) WHERE t.a=t2.b GROUP BY t.b) FROM (VALUES 1, 2) t2(b)"))).matches("VALUES false, false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(*) FROM (VALUES 1, 2, 2) t(a) WHERE t.a=t2.b GROUP BY t.a LIMIT 1) FROM (VALUES 1.0) t2(b)"))).matches("VALUES BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT EXISTS(SELECT 1 FROM (VALUES (BIGINT '1', null)) t(a, b) WHERE t.a=t2.b GROUP BY t.b) FROM (VALUES 1e0, 2e0) t2(b)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
    }

    @Test
    public void testSubqueriesWithGroupByAndConstantExpression() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT EXISTS(SELECT 1 FROM (VALUES (1, null)) t(a, b) WHERE t.a = t2.b * t2.c - 1 GROUP BY t.b) FROM (VALUES (1, 2), (2, 3)) t2(b, c)"))).matches("VALUES true, false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT EXISTS(SELECT 1 FROM (VALUES (null, null)) t(a, b) WHERE t.a = t2.b * t2.c - 1 GROUP BY t.b) FROM (VALUES (1, 2), (2, 3)) t2(b, c)"))).matches("VALUES false, false");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(*) FROM (VALUES 1, 3, 3) t(a) WHERE t.a = t2.b * t2.c - 1 GROUP BY t.a LIMIT 1) FROM (VALUES (1, 2), (2, 2)) t2(b, c)"))).matches("VALUES BIGINT '1', BIGINT '2'");
    }

    @Test
    public void testCorrelatedSubqueriesWithLimitOne() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES 1, 2, 3) t(a) WHERE t.a = t2.b LIMIT 1) FROM (VALUES 1.0, 2.0) t2(b)"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES 1, 2, 3, 4, 5, 6) t(a) WHERE t.a = t2.b * t2.c - 1 LIMIT 1) FROM (VALUES (1, 2), (2, 3)) t2(b, c)"))).matches("VALUES 1, 5");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES BIGINT '1', BIGINT '2') t(a) WHERE t.a = t2.b LIMIT 1) FROM (VALUES 1e0, 2e0) t2(b)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
    }

    @Test
    public void testCorrelatedSubqueriesWithLimitGreaterThanOne() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES 1, 2, 3) t(a) WHERE t.a = t2.b LIMIT 2) FROM (VALUES 1.0, 2.0) t2(b)"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES 1, 2, 3, 4, 5, 6) t(a) WHERE t.a = t2.b * t2.c - 1 LIMIT 2) FROM (VALUES (1, 2), (2, 3)) t2(b, c)"))).matches("VALUES 1, 5");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES BIGINT '1', BIGINT '2', BIGINT '3') t(a) WHERE t.a = t2.b LIMIT 2) FROM (VALUES 1e0, 2e0) t2(b)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
    }

    @Test
    public void testCorrelatedSubqueriesWithTopN() {
        this.assertions.assertQueryAndPlan("SELECT (SELECT t.a FROM (VALUES 1, 2, 3) t(a) WHERE t.a = t2.b ORDER BY a LIMIT 1) FROM (VALUES 1.0, 2.0) t2(b)", "VALUES 1, 2", PlanMatchPattern.output(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("cast_b", "cast_a").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_b", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference("b"), (Type)DecimalType.createDecimalType((int)11, (int)1)))), PlanMatchPattern.any(PlanMatchPattern.values("b")))).right(PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"cast_a", (Object)PlanMatchPattern.expression((Expression)new Cast((Expression)new SymbolReference("a"), (Type)DecimalType.createDecimalType((int)11, (int)1)))), PlanMatchPattern.any(PlanMatchPattern.rowNumber(rowBuilder -> rowBuilder.maxRowCountPerPartition(Optional.of(1)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.anyTree(PlanMatchPattern.values("a"))))))))));
        this.assertions.assertQueryAndPlan("SELECT (SELECT t.a FROM (VALUES 1, 2, 3, 4, 5) t(a) WHERE t.a = t2.b * t2.c - 1 ORDER BY a LIMIT 1) FROM (VALUES (1, 2), (2, 3)) t2(b, c)", "VALUES 1, 5", PlanMatchPattern.output(PlanMatchPattern.join(JoinType.LEFT, builder -> builder.equiCriteria("expr", "a").left(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"expr", (Object)PlanMatchPattern.expression((Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.SUBTRACT, (Expression)new ArithmeticBinaryExpression(ArithmeticBinaryExpression.Operator.MULTIPLY, (Expression)new SymbolReference("b"), (Expression)new SymbolReference("c")), (Expression)new LongLiteral(1L)))), PlanMatchPattern.any(PlanMatchPattern.values("b", "c")))).right(PlanMatchPattern.any(PlanMatchPattern.rowNumber(rowBuilder -> rowBuilder.maxRowCountPerPartition(Optional.of(1)).partitionBy((List<String>)ImmutableList.of((Object)"a")), PlanMatchPattern.anyTree(PlanMatchPattern.values("a"))))))));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES BIGINT '1', BIGINT '2') t(a) WHERE t.a = t2.b ORDER BY a LIMIT 1) FROM (VALUES 1e0, 2e0) t2(b)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
    }

    @Test
    public void testCorrelatedSubqueriesWithLimit() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES 1, 2) t(a) WHERE t.a=t2.b LIMIT 1) FROM (VALUES 1) t2(b)"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES 1, 2) t(a) WHERE t.a=t2.b LIMIT 2) FROM (VALUES 1) t2(b)"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES 1, 2, 3) t(a) WHERE t.a = t2.b LIMIT 2) FROM (VALUES 1) t2(b)"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES 1, 1, 2, 3) t(a) WHERE t.a = t2.b LIMIT 2) FROM (VALUES 1) t2(b)"))).failure().hasMessageMatching("Scalar sub-query has returned multiple rows");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(*) FROM (VALUES (1, 0), (1, 1)) t(a, b) WHERE a = c GROUP BY b LIMIT 1) FROM (VALUES (1)) t2(c)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT a + b FROM (VALUES (1, 1), (1, 1)) t(a, b) WHERE a = c LIMIT 1) FROM (VALUES (1)) t2(c)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.b FROM (VALUES (1, 2), (1, 3)) t(a, b) WHERE t.a = t2.a AND t.b > t2.b LIMIT 1) FROM (VALUES (1, 2)) t2(a, b)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES (1, 2), (1, 3)) t(a, b) WHERE t.a = t2.a AND t2.b > 1 LIMIT 1) FROM (VALUES (1, 2)) t2(a, b)"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.b FROM (VALUES (1, 2), (1, 3)) t(a, b) WHERE t.a = t2.a AND t.b > t2.b ORDER BY t.b LIMIT 1) FROM (VALUES (1, 2)) t2(a, b)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.b FROM (VALUES (1, 2), (1, 3)) t(a, b) WHERE t.a = t2.a AND t2.b > 1 ORDER BY t.b LIMIT 1) FROM (VALUES (1, 2)) t2(a, b)"))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT sum(t.a) FROM (VALUES 1, 2) t(a) WHERE t.a=t2.b group by t.a LIMIT 2) FROM (VALUES 1) t2(b)"))).matches("VALUES BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(*) FROM (SELECT t.a FROM (VALUES 1, 1, null, 3) t(a) WHERE t.a=t2.b LIMIT 1)) FROM (VALUES 1, 2) t2(b)"))).matches("VALUES BIGINT '1', BIGINT '0'");
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT 1 FROM (VALUES 1, 1, 3) t(a) WHERE t.a=t2.b LIMIT 1) FROM (VALUES 1, 2) t2(b)", "VALUES true, false", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("b")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.values("a")))))))));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(*) FROM (VALUES 1, 1, 3) t(a) WHERE t.a=t2.b LIMIT 1) FROM (VALUES 1) t2(b)"))).matches("VALUES BIGINT '2'");
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT 1 FROM (VALUES ('x', 1)) u(x, cid) WHERE x = 'x' AND t.cid = cid LIMIT 1) FROM (VALUES 1) t(cid)", "VALUES true", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("t_cid")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.values("u_x", "u_cid")))))))));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.a FROM (VALUES 1, 2, 3) t(a) WHERE t.a = t2.b ORDER BY a FETCH FIRST ROW WITH TIES) FROM (VALUES 1) t2(b)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) outer_relation(id) LEFT JOIN LATERAL (SELECT value FROM (VALUES (1, 'a'), (1, 'a'), (1, 'a'), (1, 'a'), (2, 'b'), (null, 'c')) inner_relation(id, value) WHERE outer_relation.id = inner_relation.id LIMIT 2) ON TRUE"))).matches("VALUES (1, 'a'), (1, 'a'), (2, 'b'), (3, null), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) outer_relation(id) LEFT JOIN LATERAL (SELECT value FROM (VALUES (1, 'd'), (1, 'c'), (1, 'b'), (1, 'a'), (2, 'w'), (null, 'x')) inner_relation(id, value) WHERE outer_relation.id = inner_relation.id ORDER BY inner_relation.value LIMIT 2) ON TRUE"))).matches("VALUES (1, 'a'), (1, 'b'), (2, 'w'), (3, null), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) outer_relation(id) LEFT JOIN LATERAL (SELECT value FROM (VALUES 'a', 'a', 'a') inner_relation(value)    WHERE outer_relation.id = 3 LIMIT 2) ON TRUE"))).matches("VALUES (1, null), (2, null), (3, 'a'), (3, 'a'), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) outer_relation(id) LEFT JOIN LATERAL (SELECT 1 FROM (VALUES 'a', 'a', 'a') inner_relation(value)    WHERE outer_relation.id = 3 LIMIT 2) ON TRUE"))).matches("VALUES (1, null), (2, null), (3, 1), (3, 1), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) outer_relation(id) LEFT JOIN LATERAL (SELECT value FROM (VALUES 'c', 'a', 'b') inner_relation(value)    WHERE outer_relation.id = 3 ORDER BY value LIMIT 2) ON TRUE"))).matches("VALUES (1, null), (2, null), (3, 'a'), (3, 'b'), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) outer_relation(id) LEFT JOIN LATERAL (SELECT value FROM (VALUES 'c', 'a', 'b') inner_relation(value)    WHERE outer_relation.id = 3 ORDER BY outer_relation.id LIMIT 2) ON TRUE"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) outer_relation(id) LEFT JOIN LATERAL (SELECT value FROM (VALUES (3, 'b'), (3, 'a'), (null, 'b')) inner_relation(id, value)    WHERE outer_relation.id = inner_relation.id ORDER BY id LIMIT 2) ON TRUE"))).matches("VALUES (1, null), (2, null), (3, 'a'), (3, 'b'), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) outer_relation(id) LEFT JOIN LATERAL (SELECT value FROM (VALUES (3, 'b'), (3, 'a'), (null, 'b')) inner_relation(id, value)    WHERE outer_relation.id = inner_relation.id ORDER BY id, value LIMIT 2) ON TRUE"))).matches("VALUES (1, null), (2, null), (3, 'a'), (3, 'b'), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) outer_relation(id) LEFT JOIN LATERAL (SELECT value FROM (VALUES (3, 'b'), (3, 'a'), (null, 'b')) inner_relation(id, value)    WHERE outer_relation.id = inner_relation.id ORDER BY value LIMIT 2) ON TRUE"))).matches("VALUES (1, null), (2, null), (3, 'a'), (3, 'b'), (null, null)");
    }

    @Test
    public void testNestedUncorrelatedSubqueryInCorrelatedSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT((SELECT b FROM (SELECT array_agg(a) FROM (VALUES 1) A(a)) B(b) WHERE b = c)) FROM (VALUES ARRAY[1], ARRAY[2]) C(c)"))).matches("VALUES ARRAY[1], null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT((SELECT b FROM (SELECT count(a) FROM (VALUES (1, 2, 3)) A(a, key_1, key_2) GROUP BY GROUPING SETS ((key_1), (key_2)) LIMIT 1) B(b) WHERE b = c)) FROM (VALUES 1, 2) C(c)"))).matches("VALUES BIGINT '1', null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT((SELECT c FROM (SELECT b FROM (VALUES (1, 2), (1, 2)) inner_relation(a, b) WHERE a = 1 LIMIT 1) C(c) WHERE c = d)) FROM (VALUES 2) D(d)"))).matches("VALUES 2");
    }

    @Test
    public void testCorrelatedSubqueriesWithGroupBy() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(*) FROM (VALUES 1, 2, 3, null) t(a) WHERE t.a<t2.b GROUP BY t.a) FROM (VALUES 1, 2, 3) t2(b)"))).failure().hasMessageMatching("Scalar sub-query has returned multiple rows");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(*) FROM (VALUES 1, 1, 2, 3, null) t(a) WHERE t.a<t2.b GROUP BY t.a HAVING count(*) > 1) FROM (VALUES 1, 2) t2(b)"))).matches("VALUES null, BIGINT '2'");
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT 1 FROM (VALUES 1, 1, 3) t(a) WHERE t.a=t2.b GROUP BY t.a) FROM (VALUES 1, 2) t2(b)", "VALUES true, false", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("b")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.values("a")))))))));
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT 1 FROM (VALUES (1, 2), (1, 2), (null, null), (3, 3)) t(a, b) WHERE t.a=t2.b GROUP BY t.a, t.b) FROM (VALUES 1, 2) t2(b)", "VALUES true, false", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("t2_b")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.values("t_a", "t_b")))))))))))));
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT 1 FROM (VALUES (1, 2), (1, 2), (null, null), (3, 3)) t(a, b) WHERE t.a<t2.b GROUP BY t.a, t.b) FROM (VALUES 1, 2) t2(b)", "VALUES false, true", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), aggregation -> aggregation.isStreamable() && aggregation.getStep() == AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("t2_b")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"NON_NULL", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.values("t_a", "t_b"))))))))));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT EXISTS(SELECT 1 FROM (VALUES (1, 1), (1, 1), (null, null), (3, 3)) t(a, b) WHERE t.a+t.b<t2.b GROUP BY t.a) FROM (VALUES 1, 2) t2(b)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT 1 FROM (VALUES (1, 1), (1, 1), (null, null), (3, 3)) t(a, b) WHERE t.a+t.b<t2.b GROUP BY t.a, t.b) FROM (VALUES 1, 4) t2(b)", "VALUES false, true", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), aggregation -> aggregation.isStreamable() && aggregation.getStep() == AggregationNode.Step.SINGLE, PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("t2_b")), PlanMatchPattern.anyTree(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"NON_NULL", (Object)PlanMatchPattern.expression((Expression)BooleanLiteral.TRUE_LITERAL)), PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.values("t_a", "t_b")))))))));
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT 1 FROM (VALUES (1, 2), (1, 2), (null, null), (3, 3)) t(a, b) WHERE t.a=t2.b GROUP BY t.b) FROM (VALUES 1, 2) t2(b)", "VALUES true, false", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("t2_b")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.values("t_a", "t_b")))))))))))));
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT * FROM (VALUES 1, 1, 2, 3) t(a) WHERE t.a=t2.b GROUP BY t.a HAVING count(*) > 1) FROM (VALUES 1, 2) t2(b)", "VALUES true, false", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("b")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.values("a")))))))));
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT EXISTS(SELECT * FROM (SELECT t.a FROM (VALUES (1, 1), (1, 1), (1, 2), (1, 2), (3, 3)) t(a, b) WHERE t.b=t2.b GROUP BY t.a HAVING count(*) > 1) t WHERE t.a=t2.b) FROM (VALUES 1, 2) t2(b)"))).matches("VALUES true, false");
        this.assertions.assertQueryAndPlan("SELECT EXISTS(SELECT * FROM (VALUES 1, 1, 2, 3) t(a) WHERE t.a=t2.b GROUP BY (t.a) HAVING count(*) > 1) FROM (VALUES 1, 2) t2(b)", "VALUES true, false", PlanMatchPattern.anyTree(PlanMatchPattern.node(JoinNode.class, PlanMatchPattern.anyTree(PlanMatchPattern.values("b")), PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), AggregationNode.Step.PARTIAL, PlanMatchPattern.anyTree(PlanMatchPattern.values("a")))))))));
    }

    @Test
    public void testCorrelatedLateralWithGroupBy() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2) t2(b), LATERAL (SELECT t.a FROM (VALUES 1, 1, 3) t(a) WHERE t.a=t2.b GROUP BY t.a)"))).matches("VALUES (1, 1)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2) t2(b), LATERAL (SELECT count(*) FROM (VALUES 1, 1, 2, 3) t(a) WHERE t.a=t2.b GROUP BY t.a HAVING count(*) > 1)"))).matches("VALUES (1, BIGINT '2')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2) t2(b), LATERAL (SELECT t.a, t.b, count(*) FROM (VALUES (1, 1), (1, 2), (2, 2), (3, 3)) t(a, b) WHERE t.a=t2.b GROUP BY GROUPING SETS ((t.a, t.b), (t.a)))"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
    }

    @Test
    public void testUncorrelatedSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 3, null) t(a) INNER JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a < b"))).matches("SELECT 1, 2");
        this.assertions.assertQueryReturnsEmptyResult("SELECT * FROM (VALUES 1, 3, null) t(a) INNER JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a * 8 < b");
        this.assertions.assertQueryReturnsEmptyResult("SELECT * FROM (SELECT 1 WHERE 0 = 1) t(a) INNER JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a < b");
        this.assertions.assertQueryReturnsEmptyResult("SELECT * FROM (VALUES 1, 3, null) t(a) INNER JOIN LATERAL (SELECT 1 WHERE 0 = 1) t2(b) ON a < b");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 3, null) t(a) LEFT JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a < b"))).matches("VALUES (1, 2), (3, null), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 3, null) t(a) LEFT JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a * 8 < b"))).matches("VALUES (1, CAST(null AS INTEGER)), (3, null), (null, null)");
        this.assertions.assertQueryReturnsEmptyResult("SELECT * FROM (SELECT 1 WHERE 0 = 1) t(a) LEFT JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a < b");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 3, null) t(a) LEFT JOIN LATERAL (SELECT 1 WHERE 0 = 1) t2(b) ON a < b"))).matches("VALUES (1, CAST(null AS INTEGER)), (3, null), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, null) t(a) RIGHT JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a < b"))).matches("VALUES (1, 2), (null, null), (null, 2), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, null) t(a) RIGHT JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a * 8 < b"))).matches("VALUES (CAST(null AS INTEGER), 2), (null, null), (null, 2), (null, null)");
        this.assertions.assertQueryReturnsEmptyResult("SELECT * FROM (SELECT 1 WHERE 0 = 1) t(a) RIGHT JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a < b");
        this.assertions.assertQueryReturnsEmptyResult("SELECT * FROM (VALUES 1, 3, null) t(a) RIGHT JOIN LATERAL (SELECT 1 WHERE 0 = 1) t2(b) ON a < b");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, null) t(a) RIGHT JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON TRUE"))).matches("VALUES (1, 2), (1, null), (null, 2), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, null) t(a) FULL JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON TRUE"))).matches("VALUES (1, 2), (1, null), (null, 2), (null, null)");
        this.assertions.assertQueryReturnsEmptyResult("SELECT * FROM (SELECT 1 WHERE 0 = 1) t(a) FULL JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON TRUE");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, null) t(a) FULL JOIN LATERAL (SELECT 1 WHERE 0 = 1) t2(b) ON TRUE"))).matches("VALUES (1, CAST(null AS INTEGER)), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, null) t(a) FULL JOIN LATERAL (SELECT * FROM (VALUES 2, null)) t2(b) ON a < b"))).failure().hasMessageMatching(".* FULL JOIN involving LATERAL relation is only supported with condition ON TRUE");
    }

    @Test
    public void testCorrelatedScalarSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2) t2(b) WHERE (SELECT b) = 2"))).matches("VALUES 2");
    }

    @Test
    public void testRemoveUnreferencedScalarSubqueryOrInput() {
        this.assertions.assertQueryReturnsEmptyResult("SELECT b FROM (VALUES 1) t(a) INNER JOIN LATERAL (SELECT 2 WHERE a = 2) t2(b) ON true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES 1) t(a) LEFT JOIN LATERAL (SELECT 2 WHERE a = 2) t2(b) ON true"))).matches("VALUES CAST(null AS INTEGER)");
        this.assertions.assertQueryReturnsEmptyResult("SELECT b FROM (VALUES 1) t(a) INNER JOIN LATERAL (SELECT 2 WHERE 0 = 1) t2(b) ON true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES 1) t(a) LEFT JOIN LATERAL (SELECT 2 WHERE 0 = 1) t2(b) ON true"))).matches("VALUES CAST(null AS INTEGER)");
        this.assertions.assertQueryReturnsEmptyResult("SELECT b FROM (VALUES 1) t(a) RIGHT JOIN LATERAL (SELECT 2 WHERE 0 = 1) t2(b) ON true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES 1) t(a) FULL JOIN LATERAL (SELECT 2 WHERE 0 = 1) t2(b) ON true"))).matches("VALUES CAST(null AS INTEGER)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1, 2) t(a) INNER JOIN LATERAL (VALUES a) t2(b) ON true"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1, 2) t(a) LEFT JOIN LATERAL (VALUES a) t2(b) ON true"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1, 2) t(a) RIGHT JOIN LATERAL (VALUES 3) t2(b) ON true"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a FROM (VALUES 1, 2) t(a) FULL JOIN LATERAL (VALUES 3) t2(b) ON true"))).matches("VALUES 1, 2");
        this.assertions.assertQueryReturnsEmptyResult("SELECT a FROM (SELECT 1 where 0 = 1) t(a) INNER JOIN LATERAL (VALUES a) t2(b) ON true");
        this.assertions.assertQueryReturnsEmptyResult("SELECT a FROM (SELECT 1 where 0 = 1) t(a) LEFT JOIN LATERAL (VALUES a) t2(b) ON true");
        this.assertions.assertQueryReturnsEmptyResult("SELECT a FROM (SELECT 1 where 0 = 1) t(a) RIGHT JOIN LATERAL (VALUES 2) t2(b) ON true");
        this.assertions.assertQueryReturnsEmptyResult("SELECT a FROM (SELECT 1 where 0 = 1) t(a) FULL JOIN LATERAL (VALUES 2) t2(b) ON true");
    }

    @Test
    public void testCorrelatedSubqueryWithExplicitCoercion() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 FROM (VALUES 1, 2) t1(b) WHERE 1 = (SELECT cast(b as decimal(7,2)))"))).matches("VALUES 1");
    }

    @Test
    public void testCorrelation() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1) t(x) WHERE EXISTS (    SELECT count(*)    FROM (VALUES 1, 2) u(y)    GROUP BY y    HAVING y = x)"))).matches("VALUES 1");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1) t(x) WHERE EXISTS (    SELECT count(*)    FROM (VALUES 1, 2) u(y)    GROUP BY y    HAVING y = t.x)"))).matches("VALUES 1");
    }

    @Test
    public void testCorrelatedSubqueryWithoutFilter() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT outer_relation.b FROM (VALUES 1) inner_relation) FROM (values 2) outer_relation(b)"))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (VALUES b) FROM (VALUES 2) outer_relation(b)"))).matches("VALUES 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT a + b FROM (VALUES 1) inner_relation(a)) FROM (VALUES 2) outer_relation(b)"))).matches("VALUES 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT rank() OVER(partition by b) FROM (VALUES 1) inner_relation(a)) FROM (VALUES 2) outer_relation(b)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
    }

    @Test
    public void testCorrelatedJoin() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) t1(a) INNER JOIN LATERAL (SELECT b FROM (VALUES 2, 3, null) t2(b) WHERE b > a) ON TRUE"))).matches("VALUES (1, 2), (1, 3), (2, 3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) t1(a) INNER JOIN LATERAL (SELECT b FROM (VALUES 2, 3, null) t2(b) WHERE b > a) ON b < 3"))).matches("VALUES (1, 2)");
        this.assertions.assertQueryReturnsEmptyResult("SELECT * FROM (SELECT 1 where 0 = 1) t(a) INNER JOIN LATERAL (SELECT 2 WHERE a = 1 ) t2(b) ON TRUE");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) t1(a) LEFT JOIN LATERAL (SELECT b FROM (VALUES 2, 3, null) t2(b) WHERE b > a) ON TRUE"))).matches("VALUES (1, 2), (1, 3), (2, 3), (3, null), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, 3, null) t1(a) LEFT JOIN LATERAL (SELECT b FROM (VALUES 2, 3, null) t2(b) WHERE b > a) ON b < 3"))).matches("VALUES (1, 2), (2, null), (3, null), (null, null)");
        this.assertions.assertQueryReturnsEmptyResult("SELECT * FROM (SELECT 1 where 0 = 1) t(a) LEFT JOIN LATERAL (SELECT 2 WHERE a = 1 ) t2(b) ON TRUE");
    }

    @Test
    public void testCorrelatedInnerUnnestWithGlobalAggregation() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT array_agg(x) FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1, 2, 3]) t(a)"))).matches("VALUES ARRAY[1, 2, 3]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(DISTINCT x) FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1, 2, 3]) t(a)"))).matches("VALUES BIGINT '3'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(DISTINCT x * 0e0) - 10e0 FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1, 2, 3]) t(a)"))).matches("VALUES -9e0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT max(count) FROM (SELECT count(v) AS count FROM UNNEST(id, val) u(i, v) GROUP BY i)) FROM (VALUES (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3])) t(id, val)"))).matches("VALUES BIGINT '2'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT histogram(e) FROM UNNEST(regexp_extract_all(x, '.')) u(e)) FROM (VALUES 'abccccdaee') t(x)"))).matches("VALUES map(cast(ARRAY['a', 'b', 'c', 'd', 'e'] AS array(varchar(10))), cast(ARRAY[2, 1, 4, 1, 2] AS array(bigint)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT array_agg(x) FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1, 2, 3], ARRAY[4], ARRAY[5, 6]) t(a)"))).matches("VALUES ARRAY[1, 2, 3], ARRAY[4], ARRAY[5, 6]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(DISTINCT x) FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1, 2, 3], ARRAY[4], ARRAY[5, 6]) t(a)"))).matches("VALUES BIGINT '3', 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT max(count) FROM (SELECT count(v) AS count FROM UNNEST(id, val) u(i, v) GROUP BY i)) FROM (VALUES (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3]), (ARRAY['c', 'd'],      ARRAY[4]), (ARRAY['e'],           ARRAY[5, 6, 7, 8])) t(id, val)"))).matches("VALUES BIGINT '2', 1, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT max(count - 5e0) * -6 FROM (SELECT count(v * 2e0) - 3 AS count FROM UNNEST(id, val) u(i, v) GROUP BY i)) FROM (VALUES (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3])) t(id, val)"))).matches("VALUES 36e0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT ROW(id, array_agg(x)) FROM UNNEST(a) u(x)) FROM (VALUES ('a', ARRAY[1, 2, 3]), ('b', ARRAY[4])) t(id, a)"))).matches("VALUES ROW(ROW('a', ARRAY[1, 2, 3])), ROW(ROW('b', ARRAY[4]))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT max(avg_ord) FROM (SELECT avg(ordinality) AS avg_ord FROM UNNEST(id, val) WITH ORDINALITY u(i, v, ordinality) GROUP BY i)) FROM (VALUES (ARRAY['a', 'b', 'b'], ARRAY[1, 2, 3])) t(id, val)"))).matches("VALUES 2.5e0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT ROW(array_agg(x), array_agg(ordinality)) FROM UNNEST(a) WITH ORDINALITY u(x, ordinality)) FROM (VALUES ARRAY[1, 2, 3], ARRAY[4], ARRAY[5, 6]) t(a)"))).matches("VALUES ROW(ROW(ARRAY[1, 2, 3], CAST(ARRAY[1, 2, 3] AS array(bigint)))), ROW(ROW(ARRAY[4], ARRAY[1])), ROW(ROW(ARRAY[5, 6], ARRAY[1, 2]))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT max(count) FROM (SELECT count(v) AS count FROM UNNEST(id, val) u(i, v) GROUP BY id)) FROM (VALUES (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3])) t(id, val)"))).nonTrinoExceptionFailure().hasMessageMatching("Grouping field .* should originate from .*");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT array_agg(x) FILTER (WHERE x < 3) FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1, 2, 3]) t(a)"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT ROW(array_agg(x) FILTER (WHERE x < 3), avg(x)) FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1, 2, 3]) t(a)"))).matches("VALUES ROW(ROW(ARRAY[1, 2], 2e0))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT array_agg(x) FROM UNNEST(a) u(x)) FROM (SELECT ARRAY[1, 2, 3] WHERE false) t(a)"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(DISTINCT x) FROM UNNEST(a) u(x)) FROM (SELECT ARRAY[1, 2, 3] WHERE false) t(a)"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT count(x) FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1, 2, 3], null, ARRAY[4], ARRAY[]) t(a)"))).matches("VALUES BIGINT '3', 0, 1, 0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT max(count) FROM (SELECT count(v) AS count FROM UNNEST(id, val) u(i, v) GROUP BY i)) FROM (VALUES (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3]), (ARRAY[],              ARRAY[]), (null,                 null)) t(id, val)"))).matches("VALUES BIGINT '2', null, null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT array_agg(y) FROM UNNEST(b) u2(y)) FROM (      SELECT (SELECT array_agg(x) FROM UNNEST(a) u(x))       FROM (VALUES ARRAY[1, 2, 3]) t(a)) t2(b)"))).matches("VALUES ARRAY[1, 2, 3]");
    }

    @Test
    public void testCorrelatedLeftUnnestWithGlobalAggregation() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3]) t(a) LEFT JOIN LATERAL (SELECT array_agg(x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES ARRAY[1, 2, 3]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3]) t(a) LEFT JOIN LATERAL (SELECT count(DISTINCT x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES BIGINT '3'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3]) t(a) LEFT JOIN LATERAL (SELECT count(DISTINCT x * 0e0) - 10e0 FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES -9e0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3])) t(id, val) LEFT JOIN LATERAL (SELECT max(count) FROM (SELECT count(v) AS count FROM (SELECT i, v FROM (VALUES 1) LEFT JOIN UNNEST(id, val) u(i, v) ON TRUE) GROUP BY i)) t2(b) ON TRUE"))).matches("VALUES BIGINT '2'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES 'abccccdaee') t(a) LEFT JOIN LATERAL (SELECT histogram(x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(regexp_extract_all(a, '.')) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES map(cast(ARRAY['a', 'b', 'c', 'd', 'e'] AS array(varchar(10))), cast(ARRAY[2, 1, 4, 1, 2] AS array(bigint)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3], ARRAY[4], ARRAY[5, 6]) t(a) LEFT JOIN LATERAL (SELECT array_agg(x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES ARRAY[1, 2, 3], ARRAY[4], ARRAY[5, 6]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3], ARRAY[4], ARRAY[5, 6]) t(a) LEFT JOIN LATERAL (SELECT count(DISTINCT x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES BIGINT '3', 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES     (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3]),     (ARRAY['c', 'd'],      ARRAY[4]),     (ARRAY['e'],           ARRAY[5, 6, 7, 8])) t(id, val) LEFT JOIN LATERAL (SELECT max(count) FROM (SELECT count(v) AS count FROM (SELECT i, v FROM (VALUES 1) LEFT JOIN UNNEST(id, val) u(i, v) ON TRUE) GROUP BY i)) t2(b) ON TRUE"))).matches("VALUES BIGINT '2', 1, 3");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3])) t(id, val) LEFT JOIN LATERAL (SELECT max(count - 5e0) * -6 FROM (SELECT count(v * 2e0) - 3 AS count FROM (SELECT i, v FROM (VALUES 1) LEFT JOIN UNNEST(id, val) u(i, v) ON TRUE) GROUP BY i)) t2(b) ON TRUE"))).matches("VALUES 36e0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ('a', ARRAY[1, 2, 3]), ('b', ARRAY[4])) t(id, a) LEFT JOIN LATERAL (SELECT ROW(id, array_agg(x)) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES ROW(ROW('a', ARRAY[1, 2, 3])), ROW(ROW('b', ARRAY[4]))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES (ARRAY['a', 'b', 'b'], ARRAY[1, 2, 3])) t(id, val) LEFT JOIN LATERAL (SELECT max(avg_ord) FROM             (SELECT avg(ordinality) AS avg_ord FROM                 (SELECT i, v, ordinality FROM (VALUES 1) LEFT JOIN UNNEST(id, val) WITH ORDINALITY u(i, v, ordinality) ON TRUE)                 GROUP BY i)        ) t2(b) ON TRUE"))).matches("VALUES 2.5e0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3], ARRAY[4], ARRAY[5, 6]) t(a) LEFT JOIN LATERAL (SELECT ROW(array_agg(x), array_agg(ordinality)) FROM (SELECT x, ordinality FROM (VALUES 1) LEFT JOIN UNNEST(a) WITH ORDINALITY u(x, ordinality) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES ROW(ROW(ARRAY[1, 2, 3], CAST(ARRAY[1, 2, 3] AS array(bigint)))), ROW(ROW(ARRAY[4], ARRAY[1])), ROW(ROW(ARRAY[5, 6], ARRAY[1, 2]))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3])) t(id, val) LEFT JOIN LATERAL (SELECT max(count) FROM (SELECT count(v) AS count FROM (SELECT i, v FROM (VALUES 1) LEFT JOIN UNNEST(id, val) u(i, v) ON TRUE) GROUP BY id)) t2(b) ON TRUE"))).nonTrinoExceptionFailure().hasMessageMatching("Grouping field .* should originate from .*");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3]) t(a) LEFT JOIN LATERAL (SELECT array_agg(x) FILTER (WHERE x < 3) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).failure().hasMessageMatching(UNSUPPORTED_CORRELATED_SUBQUERY_ERROR_MSG);
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3]) t(a) LEFT JOIN LATERAL (SELECT ROW(array_agg(x) FILTER (WHERE x < 3), avg(x)) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES ROW(ROW(ARRAY[1, 2], 2e0))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (SELECT ARRAY[1, 2, 3] WHERE FALSE) t(a) LEFT JOIN LATERAL (SELECT array_agg(x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (SELECT ARRAY[1, 2, 3] WHERE FALSE) t(a) LEFT JOIN LATERAL (SELECT count(DISTINCT x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3], null, ARRAY[4], ARRAY[]) t(a) LEFT JOIN LATERAL (SELECT count(x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES BIGINT '3', 0, 1, 0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES ARRAY[1, 2, 3], null, ARRAY[4], ARRAY[]) t(a) LEFT JOIN LATERAL (SELECT avg(x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b) ON TRUE"))).matches("VALUES 2e0, null, 4, null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT b FROM (VALUES     (ARRAY['a', 'a', 'b'], ARRAY[1, 2, 3]),     (ARRAY[],              ARRAY[]),     (null,                 null)) t(id, val) LEFT JOIN LATERAL (SELECT max(count) FROM (SELECT count(v) AS count FROM (SELECT i, v FROM (VALUES 1) LEFT JOIN UNNEST(id, val) u(i, v) ON TRUE) GROUP BY i)) t2(b) ON TRUE"))).matches("VALUES BIGINT '2', 0, 0");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT c FROM (SELECT b FROM      (VALUES ARRAY[1, 2, 3]) t(a)      LEFT JOIN      LATERAL (SELECT array_agg(x) FROM (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)) t2(b)      ON TRUE ) LEFT JOIN LATERAL (SELECT array_agg(y) FROM (SELECT y FROM (VALUES 1) LEFT JOIN UNNEST(b) w(y) ON TRUE)) t3(c) ON TRUE "))).matches("VALUES ARRAY[1, 2, 3]");
    }

    @Test
    public void testCorrelatedUnnestInScalarSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1], ARRAY[2]) t(a)"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)FROM (VALUES ARRAY[1], ARRAY[2]) t(a)"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1, 2, 3]) t(a)"))).failure().hasMessage("Scalar sub-query has returned multiple rows");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x) LIMIT 1) FROM (VALUES ARRAY[1, 1, 1], ARRAY[2, 2]) t(a)"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE LIMIT 1)FROM (VALUES ARRAY[1, 1, 1], ARRAY[2, 2]) t(a)"))).matches("VALUES 1, 2");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x) LIMIT 5) FROM (VALUES ARRAY[1], ARRAY[4]) t(a)"))).matches("VALUES 1, 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format("SELECT (SELECT * FROM UNNEST(a) u(x) LIMIT %d) FROM (VALUES ARRAY[1], ARRAY[4]) t(a)", Long.MAX_VALUE)))).matches("VALUES 1, 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x) ORDER BY x FETCH FIRST ROW WITH TIES) FROM (VALUES ARRAY[3, 1, 2], ARRAY[5, 4]) t(a)"))).matches("VALUES 1, 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE ORDER BY x FETCH FIRST ROW WITH TIES)FROM (VALUES ARRAY[3, 1, 2], ARRAY[5, 4]) t(a)"))).matches("VALUES 1, 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x) ORDER BY x FETCH FIRST 100 ROWS WITH TIES) FROM (VALUES ARRAY[1], ARRAY[4]) t(a)"))).matches("VALUES 1, 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x) ORDER BY x LIMIT 1) FROM (VALUES ARRAY[3, 1, 2], ARRAY[5, 4]) t(a)"))).matches("VALUES 1, 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE ORDER BY x LIMIT 1)FROM (VALUES ARRAY[3, 1, 2], ARRAY[5, 4]) t(a)"))).matches("VALUES 1, 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x) ORDER BY x LIMIT 100) FROM (VALUES ARRAY[1], ARRAY[4]) t(a)"))).matches("VALUES 1, 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1], ARRAY[], null) t(a)"))).matches("VALUES 1, null, null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)FROM (VALUES ARRAY[1], ARRAY[], null) t(a)"))).matches("VALUES 1, null, null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT x IS NULL FROM UNNEST(a) u(x)) FROM (VALUES ARRAY[1], ARRAY[], null) t(a)"))).matches("VALUES false, null, null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT x IS NULL FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)FROM (VALUES ARRAY[1], ARRAY[], null) t(a)"))).matches("VALUES false, true, true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT x FROM UNNEST(regexp_extract_all(a, '.')) u(x) LIMIT 1) FROM (VALUES 'xxxxxxxxxx') t(a)"))).matches("VALUES CAST('x' AS varchar(10))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT ROW(id, x) FROM UNNEST(val) u(x)) FROM (VALUES ('a', ARRAY[1]), ('b', ARRAY[2])) t(id, val)"))).matches("VALUES ROW(ROW('a', 1)), ROW(ROW('b', 2))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT ROW(x, ordinality) FROM UNNEST(a) WITH ORDINALITY u(x, ordinality)) FROM (VALUES ARRAY[1], ARRAY[2]) t(a)"))).matches("VALUES ROW(ROW(1, BIGINT '1')), ROW(ROW(2, 1))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(a) u(x)) FROM (SELECT ARRAY[1] WHERE FALSE) t(a)"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE)FROM (SELECT ARRAY[1] WHERE FALSE) t(a)"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT * FROM UNNEST(b)) FROM (SELECT (SELECT * FROM UNNEST(a))               FROM (VALUES ARRAY[ARRAY[1]], ARRAY[ARRAY[2]]) t(a)) t2(b)"))).matches("VALUES 1, 2");
    }

    @Test
    public void testCorrelatedUnnestInLateralSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[3]) t(a) INNER JOIN LATERAL (SELECT * FROM UNNEST(a)) ON TRUE"))).matches("VALUES (ARRAY[1, 2], 1), (ARRAY[1, 2], 2), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[3]) t(a) LEFT JOIN LATERAL (SELECT * FROM UNNEST(a)) ON TRUE"))).matches("VALUES (ARRAY[1, 2], 1), (ARRAY[1, 2], 2), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[3]) t(a) INNER JOIN LATERAL (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE) ON TRUE"))).matches("VALUES (ARRAY[1, 2], 1), (ARRAY[1, 2], 2), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[3]) t(a) LEFT JOIN LATERAL (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE) ON TRUE"))).matches("VALUES (ARRAY[1, 2], 1), (ARRAY[1, 2], 2), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 1], ARRAY[3]) t(a) INNER JOIN LATERAL (SELECT * FROM UNNEST(a) LIMIT 1) ON TRUE"))).matches("VALUES (ARRAY[1, 1], 1), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 1], ARRAY[3]) t(a) INNER JOIN LATERAL (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE LIMIT 1) ON TRUE"))).matches("VALUES (ARRAY[1, 1], 1), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(String.format("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[3]) t(a) INNER JOIN LATERAL (SELECT * FROM UNNEST(a) LIMIT %d) ON TRUE", Long.MAX_VALUE)))).matches("VALUES (ARRAY[1, 2], 1), (ARRAY[1, 2], 2), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[2, 1, 1], ARRAY[3]) t(a) INNER JOIN LATERAL (SELECT * FROM UNNEST(a) u(x) ORDER BY x FETCH FIRST ROW WITH TIES) ON TRUE"))).matches("VALUES (ARRAY[2, 1, 1], 1), (ARRAY[2, 1, 1], 1), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[2, 1, 1], ARRAY[3]) t(a) INNER JOIN LATERAL (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE ORDER BY x FETCH FIRST ROW WITH TIES) ON TRUE"))).matches("VALUES (ARRAY[2, 1, 1], 1), (ARRAY[2, 1, 1], 1), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[2, 2, 1, 3, 4], ARRAY[5]) t(a) INNER JOIN LATERAL (SELECT * FROM UNNEST(a) u(x) ORDER BY x FETCH FIRST 2 ROWS WITH TIES) ON TRUE"))).matches("VALUES (ARRAY[2, 2, 1, 3, 4], 1), (ARRAY[2, 2, 1, 3, 4], 2), (ARRAY[2, 2, 1, 3, 4], 2), (ARRAY[5],    5)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[2, 1, 1], ARRAY[3]) t(a) INNER JOIN LATERAL (SELECT * FROM UNNEST(a) u(x) ORDER BY x LIMIT 1) ON TRUE"))).matches("VALUES (ARRAY[2, 1, 1], 1), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[2, 1, 1], ARRAY[3]) t(a) INNER JOIN LATERAL (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE ORDER BY x LIMIT 1) ON TRUE"))).matches("VALUES (ARRAY[2, 1, 1], 1), (ARRAY[3],    3)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[2, 2, 1, 3, 4], ARRAY[5]) t(a) INNER JOIN LATERAL (SELECT * FROM UNNEST(a) u(x) ORDER BY x LIMIT 2) ON TRUE"))).matches("VALUES (ARRAY[2, 2, 1, 3, 4], 1), (ARRAY[2, 2, 1, 3, 4], 2), (ARRAY[5],    5)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[], null) t(a) LEFT JOIN LATERAL (SELECT * FROM UNNEST(a)) ON TRUE"))).matches("VALUES (ARRAY[1, 2], 1), (ARRAY[1, 2], 2), (ARRAY[], null), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[], null) t(a) INNER JOIN LATERAL (SELECT * FROM UNNEST(a)) ON TRUE"))).matches("VALUES (ARRAY[1, 2], 1), (ARRAY[1, 2], 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[], null) t(a) INNER JOIN LATERAL (SELECT x FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE) ON TRUE"))).matches("VALUES (ARRAY[1, 2], 1), (ARRAY[1, 2], 2), (ARRAY[], null), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[], null) t(a) LEFT JOIN LATERAL (SELECT x IS NULL FROM UNNEST(a) u (x)) ON TRUE"))).matches("VALUES (ARRAY[1, 2], false), (ARRAY[1, 2], false), (ARRAY[], null), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[], null) t(a) INNER JOIN LATERAL (SELECT x IS NULL FROM UNNEST(a) u(x)) ON TRUE"))).matches("VALUES (ARRAY[1, 2], false), (ARRAY[1, 2], false)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[], null) t(a) LEFT JOIN LATERAL (SELECT x IS NULL FROM (VALUES 1) LEFT JOIN UNNEST(a) u(x) ON TRUE) ON TRUE"))).matches("VALUES (ARRAY[1, 2], false), (ARRAY[1, 2], false), (ARRAY[], true), (null, true)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 'abc') t(a) INNER JOIN LATERAL (SELECT x FROM UNNEST(regexp_extract_all(a, '.')) u(x)) ON TRUE"))).matches("VALUES ('abc', CAST('a' AS varchar(3))), ('abc', 'b'), ('abc', 'c')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ('a', ARRAY[1, 2]), ('b', ARRAY[3])) t(id, val) INNER JOIN LATERAL (SELECT ROW(id, x) FROM UNNEST(val) u(x)) ON TRUE"))).matches("VALUES ('a', ARRAY[1, 2], ROW('a', 1)), ('a', ARRAY[1, 2], ROW('a', 2)), ('b', ARRAY[3], ROW('b', 3))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES ARRAY[1, 2], ARRAY[3], null) t(a) LEFT JOIN LATERAL (SELECT 100 * x + ordinality FROM UNNEST(a) WITH ORDINALITY u(x, ordinality)) ON TRUE"))).matches("VALUES (ARRAY[1, 2], BIGINT '101'), (ARRAY[1, 2], 202), (ARRAY[3], 301), (null, null)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (SELECT ARRAY[1] WHERE FALSE) t(a) INNER JOIN LATERAL (SELECT * FROM UNNEST(a)) ON TRUE"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (SELECT ARRAY[1] WHERE FALSE) t(a) LEFT JOIN LATERAL (SELECT * FROM UNNEST(a)) ON TRUE"))).returnsEmptyResult();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT y FROM        (SELECT x FROM        (VALUES ARRAY[ARRAY[1, 2, 3]], ARRAY[ARRAY[4, 5]], ARRAY[null]) t(a)        LEFT JOIN        LATERAL (SELECT * FROM UNNEST(a) u(x))        ON TRUE) t2(b)LEFT JOIN LATERAL (SELECT * FROM UNNEST(b) v(y))ON TRUE "))).matches("VALUES 1, 2, 3, 4, 5, null");
    }

    @Test
    public void testQuantifiedComparison() {
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT 2) > ALL (SELECT 1)"))).describedAs("Subquery on value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(2) > ALL (VALUES ROW(0), ROW(1))"))).describedAs("Single-element row type, non-null and non-indeterminate values", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(2) > ALL (VALUES ROW(0), ROW(1), ROW(NULL))"))).describedAs("Single-element row type, indeterminate value", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(2) > ALL (VALUES ROW(0), ROW(1), NULL)"))).describedAs("Single-element row type, null value", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(2) > ALL (SELECT 0 WHERE false)"))).describedAs("Single-element row type, with empty set", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL > ALL (VALUES ROW(0), ROW(1))"))).describedAs("Single-element row type, null value, non-null and non-indeterminate elements", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL > ALL (VALUES ROW(0), ROW(NULL))"))).describedAs("Single-element row type, null value, indeterminate element", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL > ALL (VALUES ROW(0), NULL)"))).describedAs("Single-element row type, null value, null element", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL > ALL (SELECT 0 WHERE false)"))).describedAs("Single-element row type, null value, empty set", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT BIGINT '1' = ALL (SELECT 1)"))).describedAs("Implicit row type for value side w/ coercion on subquery side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 = ALL (SELECT BIGINT '1')"))).describedAs("Implicit row type for value side w/ coercion on value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 = ALL (SELECT 1)"))).describedAs("Implicit row type for value", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(1) = ALL (SELECT 1)"))).describedAs("Explicit row type for value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(BIGINT '1') = ALL (SELECT 1)"))).describedAs("Explicit row type for value side w/ coercion on subquery side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(1) = ALL (SELECT BIGINT '1')"))).describedAs("Explicit row type for value side w/ coercion on value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(1, 2) = ALL (SELECT 1, 2)"))).describedAs("Multi-column row type", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(1, 2) = ALL (SELECT BIGINT '1', BIGINT '2')"))).describedAs("Multi-column row type with coercion on value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(BIGINT '1', BIGINT '2') = ALL (SELECT 1, 2)"))).describedAs("Multi-column row type with coercion on subquery side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(BIGINT '1', 2) = ALL (SELECT 1, BIGINT '2')"))).describedAs("Multi-column row type with coercion on both sides", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL = ALL (SELECT 1, BIGINT '2')"))).describedAs("Multi-column row type, null value", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
    }

    @Test
    public void testInPredicate() {
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT 1) IN (SELECT 1)"))).describedAs("Subquery on value side, implicit row type for value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT 2) IN (SELECT 1)"))).describedAs("Subquery on value side, implicit row type for value side", new Object[0])).matches("VALUES false");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 IN (SELECT 1)"))).describedAs("Implicit row type for value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT 1 IN (SELECT BIGINT '1')"))).describedAs("Implicit row type for value side w/ coercion on value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT BIGINT '1' IN (SELECT 1)"))).describedAs("Implicit row type for value side w/ coercion on subquery side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(1) IN (SELECT 1)"))).describedAs("Explicit row type for value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(1) IN (SELECT BIGINT '1')"))).describedAs("Explicit row type for value side w/ coercion on value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(BIGINT '1') IN (SELECT 1)"))).describedAs("Explicit row type for value side with coercion on subquery side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(0) IN (VALUES ROW(0), ROW(1))"))).describedAs("Single-element row type, non-null and non-indeterminate values, present", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(0) IN (VALUES ROW(1), ROW(2))"))).describedAs("Single-element row type, non-null and non-indeterminate values, not present", new Object[0])).matches("VALUES false");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(0) IN (VALUES ROW(0), ROW(NULL))"))).describedAs("Single-element row type, indeterminate element, present", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(0) IN (VALUES ROW(1), ROW(NULL))"))).describedAs("Single-element row type, indeterminate element, not present", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(0) IN (VALUES ROW(0), NULL)"))).describedAs("Single-element row type, null element, present", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(0) IN (VALUES ROW(1), NULL)"))).describedAs("Single-element row type, null element, not present", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(0) IN (SELECT 0 WHERE false)"))).describedAs("Single-element row type, with empty set", new Object[0])).matches("VALUES false");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL IN (VALUES ROW(0))"))).describedAs("Single-element row type, null value, non-null and non-indeterminate elements", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL IN (VALUES ROW(0), ROW(NULL))"))).describedAs("Single-element row type, null value, indeterminate element", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL IN (VALUES ROW(0), NULL)"))).describedAs("Single-element row type, null value, null element", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL IN (SELECT 0 WHERE false)"))).describedAs("Single-element row type, null value, empty set", new Object[0])).matches("VALUES false");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(1, 2) IN (SELECT 1, 2)"))).describedAs("Multi-column row type", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(1, 2) IN (SELECT BIGINT '1', BIGINT '2')"))).describedAs("Multi-column row type with coercion on value side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(BIGINT '1', BIGINT '2') IN (SELECT 1, 2)"))).describedAs("Multi-column row type with coercion on subquery side", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT ROW(BIGINT '1', 2) IN (SELECT 1, BIGINT '2')"))).describedAs("Multi-column row type with coercion on both sides", new Object[0])).matches("VALUES true");
        ((QueryAssertions.QueryAssert)((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT NULL IN (SELECT 1, BIGINT '2')"))).describedAs("Multi-column row type, null value", new Object[0])).matches("VALUES CAST(NULL AS boolean)");
    }

    @Test
    public void testRowSubquery() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT 1 AS a, 2 AS b WHERE false)"))).matches("SELECT CAST(ROW(NULL, NULL) AS row(a integer, b integer))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT 1, 2) = (SELECT ROW(1, 2))"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT 'a', 1)"))).result().hasTypes(List.of(RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((Type)VarcharType.createVarcharType((int)1)), RowType.field((Type)IntegerType.INTEGER)}))).matches("SELECT ROW('a', 1)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT 'a' AS x, 1 AS y)"))).result().hasTypes(List.of(RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"x", (Type)VarcharType.createVarcharType((int)1)), RowType.field((String)"y", (Type)IntegerType.INTEGER)}))).matches("SELECT CAST(ROW('a', 1) AS row(x varchar(1), y integer))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT * FROM (SELECT (SELECT 1, 2))"))).matches("SELECT ROW(1, 2)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* FROM (VALUES 1)) FROM (SELECT 1, 'a') t(a, b)"))).matches("SELECT CAST(ROW(1, 'a') AS row(a integer, b varchar(1)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT t.* AS (x, y) FROM (SELECT 1, 'a') t)"))).matches("SELECT CAST(ROW(1, 'a') AS row(\"X\" integer, \"Y\" varchar(1)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT 1, 2) = CAST(ROW(1,2) AS row(a bigint, b bigint))"))).matches("VALUES true");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (TABLE region ORDER BY regionkey LIMIT 1)"))).matches("SELECT CAST(ROW(0, 'AFRICA', 'lar deposits. blithely final packages cajole. regular waters are final requests. regular accounts are according to ') AS row(regionkey bigint, name varchar(25), \"comment\" varchar(152)))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT 'a' AS x, 1)"))).matches("SELECT (SELECT CAST(ROW('a', 1) AS row(x varchar(1), integer)))");
    }
}

