/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.routine;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.trino.Session;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.InputReferenceExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.routine.SqlRoutineCompiler;
import io.trino.sql.routine.ir.IrBlock;
import io.trino.sql.routine.ir.IrBreak;
import io.trino.sql.routine.ir.IrContinue;
import io.trino.sql.routine.ir.IrIf;
import io.trino.sql.routine.ir.IrLabel;
import io.trino.sql.routine.ir.IrLoop;
import io.trino.sql.routine.ir.IrRepeat;
import io.trino.sql.routine.ir.IrReturn;
import io.trino.sql.routine.ir.IrRoutine;
import io.trino.sql.routine.ir.IrSet;
import io.trino.sql.routine.ir.IrStatement;
import io.trino.sql.routine.ir.IrVariable;
import io.trino.sql.routine.ir.IrWhile;
import io.trino.testing.TestingSession;
import io.trino.util.Reflection;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;

public class TestSqlRoutineCompiler {
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private final SqlRoutineCompiler compiler = new SqlRoutineCompiler(TestingPlannerContext.PLANNER_CONTEXT.getFunctionManager());

    @Test
    public void testSimpleExpression() throws Throwable {
        IrVariable arg = new IrVariable(0, (Type)BigintType.BIGINT, (RowExpression)Expressions.constantNull((Type)BigintType.BIGINT));
        IrVariable variable = new IrVariable(1, (Type)BigintType.BIGINT, (RowExpression)Expressions.constant((Object)99L, (Type)BigintType.BIGINT));
        ResolvedFunction multiply = TestSqlRoutineCompiler.operator(OperatorType.MULTIPLY, new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        IrRoutine routine = new IrRoutine((Type)BigintType.BIGINT, TestSqlRoutineCompiler.parameters(arg), (IrStatement)new IrBlock(TestSqlRoutineCompiler.variables(variable), TestSqlRoutineCompiler.statements(new IrStatement[]{new IrSet(variable, (RowExpression)Expressions.call((ResolvedFunction)multiply, (RowExpression[])new RowExpression[]{TestSqlRoutineCompiler.reference(variable), TestSqlRoutineCompiler.reference(arg)})), new IrReturn(TestSqlRoutineCompiler.reference(variable))})));
        MethodHandle handle = this.compile(routine);
        Assertions.assertThat((Object)handle.invoke(0L)).isEqualTo((Object)0L);
        Assertions.assertThat((Object)handle.invoke(1L)).isEqualTo((Object)99L);
        Assertions.assertThat((Object)handle.invoke(42L)).isEqualTo((Object)4158L);
        Assertions.assertThat((Object)handle.invoke(123L)).isEqualTo((Object)12177L);
    }

    @Test
    public void testFibonacciWhileLoop() throws Throwable {
        IrVariable n = new IrVariable(0, (Type)BigintType.BIGINT, (RowExpression)Expressions.constantNull((Type)BigintType.BIGINT));
        IrVariable a = new IrVariable(1, (Type)BigintType.BIGINT, (RowExpression)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
        IrVariable b = new IrVariable(2, (Type)BigintType.BIGINT, (RowExpression)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
        IrVariable c = new IrVariable(3, (Type)BigintType.BIGINT, (RowExpression)Expressions.constantNull((Type)BigintType.BIGINT));
        ResolvedFunction add = TestSqlRoutineCompiler.operator(OperatorType.ADD, new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        ResolvedFunction subtract = TestSqlRoutineCompiler.operator(OperatorType.SUBTRACT, new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        ResolvedFunction lessThan = TestSqlRoutineCompiler.operator(OperatorType.LESS_THAN, new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        ResolvedFunction lessThanOrEqual = TestSqlRoutineCompiler.operator(OperatorType.LESS_THAN_OR_EQUAL, new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        IrRoutine routine = new IrRoutine((Type)BigintType.BIGINT, TestSqlRoutineCompiler.parameters(n), (IrStatement)new IrBlock(TestSqlRoutineCompiler.variables(a, b, c), TestSqlRoutineCompiler.statements(new IrStatement[]{new IrIf((RowExpression)Expressions.call((ResolvedFunction)lessThanOrEqual, (RowExpression[])new RowExpression[]{TestSqlRoutineCompiler.reference(n), Expressions.constant((Object)2L, (Type)BigintType.BIGINT)}), (IrStatement)new IrReturn((RowExpression)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)), Optional.empty()), new IrWhile(Optional.empty(), (RowExpression)Expressions.call((ResolvedFunction)lessThan, (RowExpression[])new RowExpression[]{Expressions.constant((Object)2L, (Type)BigintType.BIGINT), TestSqlRoutineCompiler.reference(n)}), new IrBlock(TestSqlRoutineCompiler.variables(new IrVariable[0]), TestSqlRoutineCompiler.statements(new IrStatement[]{new IrSet(n, (RowExpression)Expressions.call((ResolvedFunction)subtract, (RowExpression[])new RowExpression[]{TestSqlRoutineCompiler.reference(n), Expressions.constant((Object)1L, (Type)BigintType.BIGINT)})), new IrSet(c, (RowExpression)Expressions.call((ResolvedFunction)add, (RowExpression[])new RowExpression[]{TestSqlRoutineCompiler.reference(a), TestSqlRoutineCompiler.reference(b)})), new IrSet(a, TestSqlRoutineCompiler.reference(b)), new IrSet(b, TestSqlRoutineCompiler.reference(c))}))), new IrReturn(TestSqlRoutineCompiler.reference(c))})));
        MethodHandle handle = this.compile(routine);
        Assertions.assertThat((Object)handle.invoke(1L)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)handle.invoke(2L)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)handle.invoke(3L)).isEqualTo((Object)2L);
        Assertions.assertThat((Object)handle.invoke(4L)).isEqualTo((Object)3L);
        Assertions.assertThat((Object)handle.invoke(5L)).isEqualTo((Object)5L);
        Assertions.assertThat((Object)handle.invoke(6L)).isEqualTo((Object)8L);
        Assertions.assertThat((Object)handle.invoke(7L)).isEqualTo((Object)13L);
        Assertions.assertThat((Object)handle.invoke(8L)).isEqualTo((Object)21L);
    }

    @Test
    public void testBreakContinue() throws Throwable {
        IrVariable a = new IrVariable(0, (Type)BigintType.BIGINT, (RowExpression)Expressions.constant((Object)0L, (Type)BigintType.BIGINT));
        IrVariable b = new IrVariable(1, (Type)BigintType.BIGINT, (RowExpression)Expressions.constant((Object)0L, (Type)BigintType.BIGINT));
        ResolvedFunction add = TestSqlRoutineCompiler.operator(OperatorType.ADD, new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        ResolvedFunction lessThan = TestSqlRoutineCompiler.operator(OperatorType.LESS_THAN, new Type[]{BigintType.BIGINT, BigintType.BIGINT});
        IrLabel label = new IrLabel("test");
        IrRoutine routine = new IrRoutine((Type)BigintType.BIGINT, TestSqlRoutineCompiler.parameters(new IrVariable[0]), (IrStatement)new IrBlock(TestSqlRoutineCompiler.variables(a, b), TestSqlRoutineCompiler.statements(new IrStatement[]{new IrWhile(Optional.of(label), (RowExpression)Expressions.call((ResolvedFunction)lessThan, (RowExpression[])new RowExpression[]{TestSqlRoutineCompiler.reference(a), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)}), new IrBlock(TestSqlRoutineCompiler.variables(new IrVariable[0]), TestSqlRoutineCompiler.statements(new IrStatement[]{new IrSet(a, (RowExpression)Expressions.call((ResolvedFunction)add, (RowExpression[])new RowExpression[]{TestSqlRoutineCompiler.reference(a), Expressions.constant((Object)1L, (Type)BigintType.BIGINT)})), new IrIf((RowExpression)Expressions.call((ResolvedFunction)lessThan, (RowExpression[])new RowExpression[]{TestSqlRoutineCompiler.reference(a), Expressions.constant((Object)3L, (Type)BigintType.BIGINT)}), (IrStatement)new IrContinue(label), Optional.empty()), new IrSet(b, (RowExpression)Expressions.call((ResolvedFunction)add, (RowExpression[])new RowExpression[]{TestSqlRoutineCompiler.reference(b), Expressions.constant((Object)1L, (Type)BigintType.BIGINT)})), new IrIf((RowExpression)Expressions.call((ResolvedFunction)lessThan, (RowExpression[])new RowExpression[]{Expressions.constant((Object)6L, (Type)BigintType.BIGINT), TestSqlRoutineCompiler.reference(a)}), (IrStatement)new IrBreak(label), Optional.empty())}))), new IrReturn(TestSqlRoutineCompiler.reference(b))})));
        MethodHandle handle = this.compile(routine);
        Assertions.assertThat((Object)handle.invoke()).isEqualTo((Object)5L);
    }

    @Test
    public void testInterruptionWhile() throws Throwable {
        this.assertRoutineInterruption(() -> new IrWhile(Optional.empty(), (RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), new IrBlock(TestSqlRoutineCompiler.variables(new IrVariable[0]), TestSqlRoutineCompiler.statements(new IrStatement[0]))));
    }

    @Test
    public void testInterruptionRepeat() throws Throwable {
        this.assertRoutineInterruption(() -> new IrRepeat(Optional.empty(), (RowExpression)Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN), new IrBlock(TestSqlRoutineCompiler.variables(new IrVariable[0]), TestSqlRoutineCompiler.statements(new IrStatement[0]))));
    }

    @Test
    public void testInterruptionLoop() throws Throwable {
        this.assertRoutineInterruption(() -> new IrLoop(Optional.empty(), new IrBlock(TestSqlRoutineCompiler.variables(new IrVariable[0]), TestSqlRoutineCompiler.statements(new IrStatement[0]))));
    }

    private void assertRoutineInterruption(Supplier<IrStatement> loopFactory) throws Throwable {
        IrRoutine routine = new IrRoutine((Type)BigintType.BIGINT, TestSqlRoutineCompiler.parameters(new IrVariable[0]), (IrStatement)new IrBlock(TestSqlRoutineCompiler.variables(new IrVariable[0]), TestSqlRoutineCompiler.statements(new IrStatement[]{loopFactory.get(), new IrReturn((RowExpression)Expressions.constant(null, (Type)BigintType.BIGINT))})));
        MethodHandle handle = this.compile(routine);
        AtomicBoolean interrupted = new AtomicBoolean();
        Thread thread = new Thread(() -> {
            Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)(ThrowableAssert.ThrowingCallable)LambdaMetafactory.metafactory(null, null, null, ()V, invoke(), ()V)((MethodHandle)handle)).hasMessageContaining("Thread interrupted");
            interrupted.set(true);
        });
        thread.start();
        thread.interrupt();
        thread.join(TimeUnit.SECONDS.toMillis(10L));
        Assertions.assertThat((AtomicBoolean)interrupted).isTrue();
    }

    private MethodHandle compile(IrRoutine routine) throws Throwable {
        Class clazz = this.compiler.compileClass(routine);
        MethodHandle handle = (MethodHandle)Arrays.stream(clazz.getMethods()).filter(method -> method.getName().equals("run")).map(Reflection::methodHandle).collect(MoreCollectors.onlyElement());
        Object instance = Reflection.constructorMethodHandle((Class)clazz, (Class[])new Class[0]).invoke();
        return handle.bindTo(instance).bindTo(TEST_SESSION.toConnectorSession());
    }

    private static List<IrVariable> parameters(IrVariable ... variables) {
        return ImmutableList.copyOf((Object[])variables);
    }

    private static List<IrVariable> variables(IrVariable ... variables) {
        return ImmutableList.copyOf((Object[])variables);
    }

    private static List<IrStatement> statements(IrStatement ... statements) {
        return ImmutableList.copyOf((Object[])statements);
    }

    private static RowExpression reference(IrVariable variable) {
        return new InputReferenceExpression(variable.field(), variable.type());
    }

    private static ResolvedFunction operator(OperatorType operator, Type ... argumentTypes) {
        return TestingPlannerContext.PLANNER_CONTEXT.getMetadata().resolveOperator(operator, (List)ImmutableList.copyOf((Object[])argumentTypes));
    }
}

