/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class QueryTemplate {
    private final String queryTemplate;
    private final List<Parameter> defaultParameters;

    public static QueryTemplate queryTemplate(String queryTemplate, Parameter ... parameters) {
        return new QueryTemplate(queryTemplate, parameters);
    }

    public static Parameter parameter(String key) {
        return new Parameter(key);
    }

    private QueryTemplate(String queryTemplate, Parameter ... parameters) {
        for (Parameter parameter : parameters) {
            String queryParameterKey = this.asQueryParameterKey(parameter.getKey());
            Preconditions.checkArgument((boolean)queryTemplate.contains(queryParameterKey), (String)"Query template does not contain: %s", (Object)queryParameterKey);
        }
        this.queryTemplate = queryTemplate;
        this.defaultParameters = ImmutableList.copyOf((Object[])parameters);
    }

    public String replace(Parameter ... parameters) {
        String query = this.queryTemplate;
        for (Parameter parameter : parameters) {
            query = this.resolve(query, parameter);
        }
        for (Parameter parameter : this.defaultParameters) {
            query = this.resolve(query, parameter);
        }
        this.checkQueryHasAllParametersReplaced(query);
        return query;
    }

    private void checkQueryHasAllParametersReplaced(String query) {
        for (Parameter parameter : this.defaultParameters) {
            String queryParameterKey = this.asQueryParameterKey(parameter.getKey());
            Preconditions.checkArgument((!query.contains(queryParameterKey) ? 1 : 0) != 0, (String)"Query template parameters was not given: %s", (Object)queryParameterKey);
        }
    }

    @SafeVarargs
    public final Stream<String> replaceAll(List<Parameter> ... parametersLists) {
        ArrayList queries = new ArrayList();
        this.replaceAll(queries::add, parametersLists);
        return queries.stream();
    }

    @SafeVarargs
    public final void replaceAll(Consumer<String> queryConsumer, List<Parameter> ... parametersLists) {
        Objects.requireNonNull(queryConsumer, "queryConsumer is null");
        this.replaceAll(this.queryTemplate, queryConsumer, (List<List<Parameter>>)ImmutableList.copyOf((Object[])parametersLists));
    }

    private void replaceAll(String queryTemplate, Consumer<String> queryConsumer, List<List<Parameter>> parametersLists) {
        if (parametersLists.size() == 0) {
            this.checkQueryHasAllParametersReplaced(queryTemplate);
            queryConsumer.accept(queryTemplate);
        } else {
            List restParameters = (List)IntStream.range(1, parametersLists.size()).mapToObj(parametersLists::get).collect(ImmutableList.toImmutableList());
            for (Parameter parameter : parametersLists.get(0)) {
                String intermediateQueryTemplate = this.resolve(queryTemplate, parameter);
                this.replaceAll(intermediateQueryTemplate, queryConsumer, restParameters);
            }
        }
    }

    private String resolve(String query, Parameter parameter) {
        return parameter.getValue().map(value -> query.replaceAll(this.asQueryParameterKey(parameter.getKey()), (String)value)).orElse(query);
    }

    private String asQueryParameterKey(String key) {
        return "%" + key + "%";
    }

    public static final class Parameter {
        private final String key;
        private final Optional<String> value;

        private Parameter(String key) {
            this(key, Optional.empty());
        }

        private Parameter(String key, String value) {
            this(key, Optional.of(value));
        }

        private Parameter(String key, Optional<String> value) {
            this.key = Objects.requireNonNull(key, "key is null");
            this.value = Objects.requireNonNull(value, "value is null");
        }

        public Optional<String> getValue() {
            return this.value;
        }

        public String getKey() {
            return this.key;
        }

        public Parameter of(String value) {
            return new Parameter(this.key, value);
        }

        public List<Parameter> of(String ... values) {
            return (List)Arrays.stream(values).map(this::of).collect(ImmutableList.toImmutableList());
        }
    }
}

