/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.MapValueBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.InternalTypeManager;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public final class StructuralTestUtil {
    private StructuralTestUtil() {
    }

    public static Block arrayBlockOf(Type elementType, Object ... values) {
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, values.length);
        for (Object value : values) {
            StructuralTestUtil.appendToBlockBuilder(elementType, value, blockBuilder);
        }
        return blockBuilder.build();
    }

    public static SqlMap sqlMapOf(Type keyType, Type valueType, Map<?, ?> map) {
        return MapValueBuilder.buildMapValue((MapType)StructuralTestUtil.mapType(keyType, valueType), (int)map.size(), (keyBuilder, valueBuilder) -> map.forEach((key, value) -> {
            StructuralTestUtil.appendToBlockBuilder(keyType, key, keyBuilder);
            StructuralTestUtil.appendToBlockBuilder(valueType, value, valueBuilder);
        }));
    }

    public static MapType mapType(Type keyType, Type valueType) {
        return (MapType)InternalTypeManager.TESTING_TYPE_MANAGER.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.typeParameter((TypeSignature)keyType.getTypeSignature()), (Object)TypeSignatureParameter.typeParameter((TypeSignature)valueType.getTypeSignature())));
    }

    public static SqlRow sqlRowOf(RowType rowType, Object ... values) {
        return RowValueBuilder.buildRowValue((RowType)rowType, fieldBuilders -> {
            for (int i = 0; i < values.length; ++i) {
                StructuralTestUtil.appendToBlockBuilder((Type)rowType.getTypeParameters().get(i), values[i], (BlockBuilder)fieldBuilders.get(i));
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void appendToBlockBuilder(Type type, Object element, BlockBuilder blockBuilder) {
        Class javaType = type.getJavaType();
        if (element == null) {
            blockBuilder.appendNull();
            return;
        }
        if (type instanceof ArrayType && element instanceof Iterable) {
            ((ArrayBlockBuilder)blockBuilder).buildEntry(elementBuilder -> {
                for (Object subElement : (Iterable)element) {
                    StructuralTestUtil.appendToBlockBuilder((Type)type.getTypeParameters().get(0), subElement, elementBuilder);
                }
            });
            return;
        }
        if (type instanceof RowType && element instanceof Iterable) {
            ((RowBlockBuilder)blockBuilder).buildEntry(fieldBuilders -> {
                int field = 0;
                for (Object subElement : (Iterable)element) {
                    StructuralTestUtil.appendToBlockBuilder((Type)type.getTypeParameters().get(field), subElement, (BlockBuilder)fieldBuilders.get(field));
                    ++field;
                }
            });
            return;
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            if (element instanceof Map) {
                ((MapBlockBuilder)blockBuilder).buildEntry((keyBuilder, valueBuilder) -> {
                    for (Map.Entry entry : ((Map)element).entrySet()) {
                        StructuralTestUtil.appendToBlockBuilder(mapType.getKeyType(), entry.getKey(), keyBuilder);
                        StructuralTestUtil.appendToBlockBuilder(mapType.getValueType(), entry.getValue(), valueBuilder);
                    }
                });
                return;
            }
        }
        if (javaType == Boolean.TYPE) {
            type.writeBoolean(blockBuilder, ((Boolean)element).booleanValue());
            return;
        }
        if (javaType == Long.TYPE) {
            if (element instanceof SqlDecimal) {
                type.writeLong(blockBuilder, ((SqlDecimal)element).getUnscaledValue().longValue());
                return;
            }
            if (RealType.REAL.equals((Object)type)) {
                type.writeLong(blockBuilder, (long)Float.floatToRawIntBits(((Number)element).floatValue()));
                return;
            }
            type.writeLong(blockBuilder, ((Number)element).longValue());
            return;
        }
        if (javaType == Double.TYPE) {
            type.writeDouble(blockBuilder, ((Number)element).doubleValue());
            return;
        }
        if (javaType == Slice.class) {
            if (element instanceof String) {
                type.writeSlice(blockBuilder, Slices.utf8Slice((String)element.toString()));
                return;
            }
            if (element instanceof byte[]) {
                type.writeSlice(blockBuilder, Slices.wrappedBuffer((byte[])((byte[])element)));
                return;
            }
            type.writeSlice(blockBuilder, (Slice)element);
            return;
        }
        if (element instanceof SqlDecimal) {
            type.writeObject(blockBuilder, (Object)Int128.valueOf((BigInteger)((SqlDecimal)element).getUnscaledValue()));
            return;
        }
        if (element instanceof BigDecimal) {
            type.writeObject(blockBuilder, (Object)Decimals.valueOf((BigDecimal)((BigDecimal)element)));
            return;
        }
        type.writeObject(blockBuilder, element);
    }
}

