/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system.jdbc;

import io.airlift.slice.Slice;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.spi.predicate.Domain;
import java.util.Locale;
import java.util.Optional;

public final class FilterUtil {
    private FilterUtil() {
    }

    public static <T> Optional<String> tryGetSingleVarcharValue(Domain domain) {
        if (!domain.isSingleValue()) {
            return Optional.empty();
        }
        Object value = domain.getSingleValue();
        return Optional.of(((Slice)value).toStringUtf8());
    }

    public static QualifiedTablePrefix tablePrefix(String catalog, Optional<String> schema, Optional<String> table) {
        if (schema.isPresent() && table.isPresent()) {
            return new QualifiedTablePrefix(catalog, schema.get(), table.get());
        }
        if (schema.isPresent()) {
            return new QualifiedTablePrefix(catalog, schema.get());
        }
        return new QualifiedTablePrefix(catalog);
    }

    public static boolean isImpossibleObjectName(Domain domain) {
        if (!domain.isNullableDiscreteSet()) {
            return false;
        }
        Domain.DiscreteSet discreteSet = domain.getNullableDiscreteSet();
        return discreteSet.getNonNullValues().stream().allMatch(element -> FilterUtil.isImpossibleObjectName(((Slice)element).toStringUtf8()));
    }

    public static boolean isImpossibleObjectName(String candidate) {
        return candidate.equals("") || !candidate.equals(candidate.toLowerCase(Locale.ENGLISH));
    }
}

