/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.MaterializedViewPropertyManager;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TablePropertyManager;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.sql.PlannerContext;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SetPropertiesTask
implements DataDefinitionTask<SetProperties> {
    private final PlannerContext plannerContext;
    private final AccessControl accessControl;
    private final TablePropertyManager tablePropertyManager;
    private final MaterializedViewPropertyManager materializedViewPropertyManager;

    @Inject
    public SetPropertiesTask(PlannerContext plannerContext, AccessControl accessControl, TablePropertyManager tablePropertyManager, MaterializedViewPropertyManager materializedViewPropertyManager) {
        this.plannerContext = Objects.requireNonNull(plannerContext, "plannerContext is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.tablePropertyManager = Objects.requireNonNull(tablePropertyManager, "tablePropertyManager is null");
        this.materializedViewPropertyManager = Objects.requireNonNull(materializedViewPropertyManager, "materializedViewPropertyManager is null");
    }

    @Override
    public String getName() {
        return "SET PROPERTIES";
    }

    @Override
    public ListenableFuture<Void> execute(SetProperties statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        QualifiedObjectName objectName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName());
        String catalogName = objectName.getCatalogName();
        if (statement.getType() == SetProperties.Type.TABLE) {
            Map properties = this.tablePropertyManager.getNullableProperties(catalogName, MetadataUtil.getRequiredCatalogHandle(this.plannerContext.getMetadata(), session, (Node)statement, catalogName), (Iterable)statement.getProperties(), session, this.plannerContext, this.accessControl, (Map)ParameterExtractor.bindParameters((Statement)statement, parameters), false);
            this.setTableProperties(statement, objectName, session, properties);
        } else if (statement.getType() == SetProperties.Type.MATERIALIZED_VIEW) {
            Map properties = this.materializedViewPropertyManager.getNullableProperties(catalogName, MetadataUtil.getRequiredCatalogHandle(this.plannerContext.getMetadata(), session, (Node)statement, catalogName), (Iterable)statement.getProperties(), session, this.plannerContext, this.accessControl, (Map)ParameterExtractor.bindParameters((Statement)statement, parameters), false);
            this.setMaterializedViewProperties(statement, objectName, session, properties);
        } else {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Unsupported target type: %s", statement.getType());
        }
        return Futures.immediateVoidFuture();
    }

    private void setTableProperties(SetProperties statement, QualifiedObjectName tableName, Session session, Map<String, Optional<Object>> properties) {
        if (this.plannerContext.getMetadata().isMaterializedView(session, tableName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot set properties to a materialized view in ALTER TABLE", new Object[0]);
        }
        if (this.plannerContext.getMetadata().isView(session, tableName)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot set properties to a view in ALTER TABLE", new Object[0]);
        }
        TableHandle tableHandle = this.plannerContext.getMetadata().getTableHandle(session, tableName).orElseThrow(() -> SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Table does not exist: %s", tableName));
        this.accessControl.checkCanSetTableProperties(session.toSecurityContext(), tableName, properties);
        this.plannerContext.getMetadata().setTableProperties(session, tableHandle, properties);
    }

    private void setMaterializedViewProperties(SetProperties statement, QualifiedObjectName materializedViewName, Session session, Map<String, Optional<Object>> properties) {
        if (this.plannerContext.getMetadata().getMaterializedView(session, materializedViewName).isEmpty()) {
            Object additionalInformation = this.plannerContext.getMetadata().isView(session, materializedViewName) ? ", but a view with that name exists." : (this.plannerContext.getMetadata().getTableHandle(session, materializedViewName).isPresent() ? ", but a table with that name exists. Did you mean ALTER TABLE " + String.valueOf(materializedViewName) + " SET PROPERTIES ...?" : "");
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.TABLE_NOT_FOUND, (Node)statement, "Materialized View '%s' does not exist%s", materializedViewName, additionalInformation);
        }
        this.accessControl.checkCanSetMaterializedViewProperties(session.toSecurityContext(), materializedViewName, properties);
        this.plannerContext.getMetadata().setMaterializedViewProperties(session, materializedViewName, properties);
    }
}

