/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.cache.CacheUtils;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.CatalogFunctionMetadata;
import io.trino.metadata.FunctionBinder;
import io.trino.metadata.FunctionBinding;
import io.trino.metadata.FunctionResolver;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNameUtil;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.sql.analyzer.TypeSignatureProvider;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class BuiltinFunctionResolver {
    private final Metadata metadata;
    private final TypeManager typeManager;
    private final GlobalFunctionCatalog globalFunctionCatalog;
    private final FunctionBinder functionBinder;
    private final ResolvedFunction.ResolvedFunctionDecoder functionDecoder;
    private final NonEvictableCache<OperatorCacheKey, ResolvedFunction> operatorCache;
    private final NonEvictableCache<CoercionCacheKey, ResolvedFunction> coercionCache;

    public BuiltinFunctionResolver(Metadata metadata, TypeManager typeManager, GlobalFunctionCatalog globalFunctionCatalog, ResolvedFunction.ResolvedFunctionDecoder functionDecoder) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.globalFunctionCatalog = Objects.requireNonNull(globalFunctionCatalog, "globalFunctionCatalog is null");
        this.functionDecoder = functionDecoder;
        this.functionBinder = new FunctionBinder(metadata, typeManager);
        this.operatorCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));
        this.coercionCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L));
    }

    ResolvedFunction resolveBuiltinFunction(String name, List<TypeSignatureProvider> parameterTypes) {
        FunctionBinder.CatalogFunctionBinding functionBinding = this.functionBinder.bindFunction(parameterTypes, this.getBuiltinFunctions(name), name);
        return this.resolveBuiltin(functionBinding);
    }

    ResolvedFunction resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        try {
            return (ResolvedFunction)CacheUtils.uncheckedCacheGet(this.operatorCache, (Object)new OperatorCacheKey(operatorType, argumentTypes), () -> this.resolveBuiltinFunction(OperatorNameUtil.mangleOperatorName(operatorType), (List)argumentTypes.stream().map(Type::getTypeSignature).map(TypeSignatureProvider::new).collect(ImmutableList.toImmutableList())));
        }
        catch (UncheckedExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TrinoException) {
                TrinoException cause = (TrinoException)throwable;
                if (cause.getErrorCode().getCode() == StandardErrorCode.FUNCTION_NOT_FOUND.toErrorCode().getCode()) {
                    throw new OperatorNotFoundException(operatorType, argumentTypes, cause);
                }
                throw cause;
            }
            throw e;
        }
    }

    ResolvedFunction resolveCoercion(OperatorType operatorType, Type fromType, Type toType) {
        Preconditions.checkArgument((operatorType == OperatorType.CAST || operatorType == OperatorType.SATURATED_FLOOR_CAST ? 1 : 0) != 0);
        try {
            return (ResolvedFunction)CacheUtils.uncheckedCacheGet(this.coercionCache, (Object)new CoercionCacheKey(operatorType, fromType, toType), () -> this.resolveCoercion(OperatorNameUtil.mangleOperatorName(operatorType), fromType, toType));
        }
        catch (UncheckedExecutionException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof TrinoException) {
                TrinoException cause = (TrinoException)throwable;
                if (cause.getErrorCode().getCode() == StandardErrorCode.FUNCTION_IMPLEMENTATION_MISSING.toErrorCode().getCode()) {
                    throw new OperatorNotFoundException(operatorType, (List<? extends Type>)ImmutableList.of((Object)fromType), toType.getTypeSignature(), cause);
                }
                throw cause;
            }
            throw e;
        }
    }

    ResolvedFunction resolveCoercion(String functionName, Type fromType, Type toType) {
        FunctionBinder.CatalogFunctionBinding functionBinding = this.functionBinder.bindCoercion(Signature.builder().returnType(toType).argumentType(fromType).build(), this.getBuiltinFunctions(functionName));
        return this.resolveBuiltin(functionBinding);
    }

    private ResolvedFunction resolveBuiltin(FunctionBinder.CatalogFunctionBinding functionBinding) {
        FunctionBinding binding = functionBinding.functionBinding();
        FunctionDependencyDeclaration dependencies = this.globalFunctionCatalog.getFunctionDependencies(binding.getFunctionId(), binding.getBoundSignature());
        return FunctionResolver.resolveFunctionBinding(this.metadata, this.typeManager, this.functionBinder, this.functionDecoder, GlobalSystemConnector.CATALOG_HANDLE, functionBinding.functionBinding(), functionBinding.functionMetadata(), dependencies, catalogSchemaFunctionName -> {
            if (!GlobalFunctionCatalog.isBuiltinFunctionName(catalogSchemaFunctionName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Builtin function %s cannot depend on a non-builtin function: %s", functionBinding.functionBinding().getBoundSignature().getName(), catalogSchemaFunctionName));
            }
            return this.getBuiltinFunctions(catalogSchemaFunctionName.getFunctionName());
        }, this::resolveBuiltin);
    }

    private Collection<CatalogFunctionMetadata> getBuiltinFunctions(String functionName) {
        return (Collection)this.globalFunctionCatalog.getBuiltInFunctions(functionName).stream().map(function -> new CatalogFunctionMetadata(GlobalSystemConnector.CATALOG_HANDLE, "builtin", (FunctionMetadata)function)).collect(ImmutableList.toImmutableList());
    }

    private record OperatorCacheKey(OperatorType operatorType, List<? extends Type> argumentTypes) {
        private OperatorCacheKey {
            Objects.requireNonNull(operatorType, "operatorType is null");
            argumentTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentTypes, "argumentTypes is null"));
        }
    }

    private record CoercionCacheKey(OperatorType operatorType, Type fromType, Type toType) {
        private CoercionCacheKey {
            Objects.requireNonNull(operatorType, "operatorType is null");
            Objects.requireNonNull(fromType, "fromType is null");
            Objects.requireNonNull(toType, "toType is null");
        }
    }
}

