/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.inject.Inject;
import io.trino.operator.GroupByHashPageIndexer;
import io.trino.spi.Page;
import io.trino.spi.PageIndexer;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.type.Type;
import io.trino.sql.gen.JoinCompiler;
import java.util.List;
import java.util.Objects;

public class GroupByHashPageIndexerFactory
implements PageIndexerFactory {
    private final JoinCompiler joinCompiler;

    @Inject
    public GroupByHashPageIndexerFactory(JoinCompiler joinCompiler) {
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
    }

    public PageIndexer createPageIndexer(List<Type> types) {
        if (types.isEmpty()) {
            return new NoHashPageIndexer();
        }
        return new GroupByHashPageIndexer(types, this.joinCompiler);
    }

    private static class NoHashPageIndexer
    implements PageIndexer {
        private NoHashPageIndexer() {
        }

        public int[] indexPage(Page page) {
            return new int[page.getPositionCount()];
        }

        public int getMaxIndex() {
            return 0;
        }
    }
}

