/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import io.trino.execution.TaskId;
import io.trino.operator.DirectExchangeBuffer;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;

public class StreamingDirectExchangeBuffer
implements DirectExchangeBuffer {
    private static final Logger log = Logger.get(StreamingDirectExchangeBuffer.class);
    private final Executor executor;
    private final long bufferCapacityInBytes;
    @GuardedBy(value="this")
    private final Queue<Slice> bufferedPages = new ArrayDeque<Slice>();
    @GuardedBy(value="this")
    private volatile long bufferRetainedSizeInBytes;
    @GuardedBy(value="this")
    private volatile long maxBufferRetainedSizeInBytes;
    @GuardedBy(value="this")
    private final Queue<SettableFuture<Void>> blocked = new ArrayDeque<SettableFuture<Void>>();
    @GuardedBy(value="this")
    private final Set<TaskId> activeTasks = new HashSet<TaskId>();
    @GuardedBy(value="this")
    private boolean noMoreTasks;
    @GuardedBy(value="this")
    private Throwable failure;
    @GuardedBy(value="this")
    private boolean closed;

    public StreamingDirectExchangeBuffer(Executor executor, DataSize bufferCapacity) {
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.bufferCapacityInBytes = bufferCapacity.toBytes();
    }

    @Override
    public synchronized ListenableFuture<Void> isBlocked() {
        if (!this.bufferedPages.isEmpty() || this.isFailed() || this.noMoreTasks && this.activeTasks.isEmpty()) {
            return Futures.immediateVoidFuture();
        }
        SettableFuture callback = SettableFuture.create();
        this.blocked.add((SettableFuture<Void>)callback);
        return Futures.nonCancellationPropagating((ListenableFuture)callback);
    }

    @Override
    public synchronized Slice pollPage() {
        this.throwIfFailed();
        if (this.closed) {
            return null;
        }
        Slice page = this.bufferedPages.poll();
        if (page != null) {
            this.bufferRetainedSizeInBytes -= page.getRetainedSize();
            Preconditions.checkState((this.bufferRetainedSizeInBytes >= 0L ? 1 : 0) != 0, (String)"unexpected bufferRetainedSizeInBytes: %s", (long)this.bufferRetainedSizeInBytes);
        }
        return page;
    }

    @Override
    public synchronized void addTask(TaskId taskId) {
        if (this.closed) {
            return;
        }
        Preconditions.checkState((!this.noMoreTasks ? 1 : 0) != 0, (Object)"no more tasks are expected");
        this.activeTasks.add(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPages(TaskId taskId, List<Slice> pages) {
        long pagesRetainedSizeInBytes = 0L;
        for (Slice page : pages) {
            pagesRetainedSizeInBytes += page.getRetainedSize();
        }
        StreamingDirectExchangeBuffer streamingDirectExchangeBuffer = this;
        synchronized (streamingDirectExchangeBuffer) {
            if (this.closed) {
                return;
            }
            Preconditions.checkState((boolean)this.activeTasks.contains(taskId), (String)"taskId is not active: %s", (Object)taskId);
            this.bufferedPages.addAll(pages);
            this.bufferRetainedSizeInBytes += pagesRetainedSizeInBytes;
            this.maxBufferRetainedSizeInBytes = Math.max(this.maxBufferRetainedSizeInBytes, this.bufferRetainedSizeInBytes);
            this.unblock(pages.size());
        }
    }

    @Override
    public synchronized void taskFinished(TaskId taskId) {
        if (this.closed) {
            return;
        }
        Preconditions.checkState((boolean)this.activeTasks.contains(taskId), (String)"taskId not registered: %s", (Object)taskId);
        this.activeTasks.remove(taskId);
        if (this.noMoreTasks && this.activeTasks.isEmpty()) {
            this.unblockAll();
        }
    }

    @Override
    public synchronized void taskFailed(TaskId taskId, Throwable t) {
        if (this.closed) {
            return;
        }
        Preconditions.checkState((boolean)this.activeTasks.contains(taskId), (String)"taskId not registered: %s", (Object)taskId);
        if (t instanceof TrinoException && StandardErrorCode.REMOTE_TASK_FAILED.toErrorCode().equals((Object)((TrinoException)t).getErrorCode())) {
            log.debug("Task failure discovered while fetching task results: %s", new Object[]{taskId});
            return;
        }
        this.failure = t;
        this.activeTasks.remove(taskId);
        this.unblockAll();
    }

    @Override
    public synchronized void noMoreTasks() {
        this.noMoreTasks = true;
        if (this.activeTasks.isEmpty()) {
            this.unblockAll();
        }
    }

    @Override
    public synchronized boolean isFinished() {
        return this.failure == null && this.noMoreTasks && this.activeTasks.isEmpty() && this.bufferedPages.isEmpty();
    }

    @Override
    public synchronized boolean isFailed() {
        return this.failure != null;
    }

    @Override
    public long getRemainingCapacityInBytes() {
        return Math.max(this.bufferCapacityInBytes - this.bufferRetainedSizeInBytes, 0L);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.bufferRetainedSizeInBytes;
    }

    @Override
    public long getMaxRetainedSizeInBytes() {
        return this.maxBufferRetainedSizeInBytes;
    }

    @Override
    public synchronized int getBufferedPageCount() {
        return this.bufferedPages.size();
    }

    @Override
    public long getSpilledBytes() {
        return 0L;
    }

    @Override
    public int getSpilledPageCount() {
        return 0;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.bufferedPages.clear();
        this.bufferRetainedSizeInBytes = 0L;
        this.activeTasks.clear();
        this.noMoreTasks = true;
        this.closed = true;
        this.unblockAll();
    }

    private synchronized void unblock(int unblock) {
        SettableFuture<Void> callback;
        for (int i = 0; i < unblock && (callback = this.blocked.poll()) != null; ++i) {
            this.executor.execute(() -> callback.set(null));
        }
    }

    private synchronized void unblockAll() {
        this.unblock(this.blocked.size());
        Preconditions.checkState((boolean)this.blocked.isEmpty(), (Object)"blocked callbacks is not empty");
    }

    private synchronized void throwIfFailed() {
        if (this.failure != null) {
            Throwables.throwIfUnchecked((Throwable)this.failure);
            throw new RuntimeException(this.failure);
        }
    }
}

