/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.LongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.RemoveInputFunction;
import io.trino.spi.type.BigintType;

@AggregationFunction(value="count")
public final class CountAggregation {
    private CountAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LongState state) {
        state.setValue(state.getValue() + 1L);
    }

    @RemoveInputFunction
    public static boolean removeInput(@AggregationState LongState state) {
        state.setValue(state.getValue() - 1L);
        return true;
    }

    @CombineFunction
    public static void combine(@AggregationState LongState state, @AggregationState LongState otherState) {
        state.setValue(state.getValue() + otherState.getValue());
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getValue());
    }
}

