/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.DoubleState;
import io.trino.operator.aggregation.state.LongState;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.RemoveInputFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.RealType;

@AggregationFunction(value="avg")
@Description(value="Returns the average value of the argument")
public final class RealAverageAggregation {
    private RealAverageAggregation() {
    }

    @InputFunction
    public static void input(@AggregationState LongState count, @AggregationState DoubleState sum, @SqlType(value="REAL") long value) {
        count.setValue(count.getValue() + 1L);
        sum.setValue(sum.getValue() + (double)Float.intBitsToFloat((int)value));
    }

    @RemoveInputFunction
    public static boolean removeInput(@AggregationState LongState count, @AggregationState DoubleState sum, @SqlType(value="REAL") long value) {
        double currentValue = sum.getValue();
        if (Double.isFinite(currentValue)) {
            sum.setValue(currentValue - (double)Float.intBitsToFloat((int)value));
            count.setValue(count.getValue() - 1L);
            return true;
        }
        return false;
    }

    @CombineFunction
    public static void combine(@AggregationState LongState count, @AggregationState DoubleState sum, @AggregationState LongState otherCount, @AggregationState DoubleState otherSum) {
        count.setValue(count.getValue() + otherCount.getValue());
        sum.setValue(sum.getValue() + otherSum.getValue());
    }

    @OutputFunction(value="REAL")
    public static void output(@AggregationState LongState count, @AggregationState DoubleState sum, BlockBuilder out) {
        if (count.getValue() == 0L) {
            out.appendNull();
        } else {
            RealType.REAL.writeLong(out, (long)Float.floatToIntBits((float)(sum.getValue() / (double)count.getValue())));
        }
    }
}

