/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;

public class LongDecimalWithOverflowStateSerializer
implements AccumulatorStateSerializer<LongDecimalWithOverflowState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(LongDecimalWithOverflowState state, BlockBuilder out) {
        if (!state.isNotNull()) {
            out.appendNull();
            return;
        }
        long overflow = state.getOverflow();
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        Slice buffer = Slices.allocate((int)24);
        long low = decimal[offset + 1];
        long high = decimal[offset];
        buffer.setLong(0, low);
        buffer.setLong(8, high);
        buffer.setLong(16, overflow);
        int decimalsCount = 1 + (high == 0L ? 0 : 1);
        int bufferLength = overflow == 0L ? decimalsCount : 3;
        VarbinaryType.VARBINARY.writeSlice(out, buffer, 0, bufferLength * 8);
    }

    public void deserialize(Block block, int index, LongDecimalWithOverflowState state) {
        if (block.isNull(index)) {
            return;
        }
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block;
        Slice slice = variableWidthBlock.getRawSlice();
        int sliceOffset = variableWidthBlock.getRawSliceOffset(index);
        int sliceLength = variableWidthBlock.getSliceLength(index);
        long[] decimal = state.getDecimalArray();
        int offset = state.getDecimalArrayOffset();
        long low = slice.getLong(sliceOffset);
        long high = 0L;
        long overflow = 0L;
        if (sliceLength == 24) {
            overflow = slice.getLong(sliceOffset + 16);
            high = slice.getLong(sliceOffset + 8);
        } else if (sliceLength == 16) {
            high = slice.getLong(sliceOffset + 8);
        }
        decimal[offset + 1] = low;
        decimal[offset] = high;
        state.setOverflow(overflow);
        state.setNotNull();
    }
}

