/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public final class ArithmeticUnaryExpression
extends Expression {
    private final Expression value;
    private final Sign sign;

    @JsonCreator
    public ArithmeticUnaryExpression(Sign sign, Expression value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(sign, "sign is null");
        this.value = value;
        this.sign = sign;
    }

    public static ArithmeticUnaryExpression positive(Expression value) {
        return new ArithmeticUnaryExpression(Sign.PLUS, value);
    }

    public static ArithmeticUnaryExpression negative(Expression value) {
        return new ArithmeticUnaryExpression(Sign.MINUS, value);
    }

    @JsonProperty
    public Expression getValue() {
        return this.value;
    }

    @JsonProperty
    public Sign getSign() {
        return this.sign;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticUnary(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArithmeticUnaryExpression that = (ArithmeticUnaryExpression)o;
        return Objects.equals(this.value, that.value) && this.sign == that.sign;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.sign});
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = switch (this.sign.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "+";
            case 1 -> "-";
        };
        objectArray[1] = this.value;
        return "%s(%s)".formatted(objectArray);
    }

    public static enum Sign {
        PLUS,
        MINUS;

    }
}

