/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Array
extends Expression {
    private final List<Expression> values;

    @JsonCreator
    public Array(List<Expression> values) {
        Objects.requireNonNull(values, "values is null");
        this.values = ImmutableList.copyOf(values);
    }

    @JsonProperty
    public List<Expression> getValues() {
        return this.values;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitArray(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Array that = (Array)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "Array[%s]".formatted(this.values.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }
}

