/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public final class BetweenPredicate
extends Expression {
    private final Expression value;
    private final Expression min;
    private final Expression max;

    @JsonCreator
    public BetweenPredicate(Expression value, Expression min, Expression max) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(min, "min is null");
        Objects.requireNonNull(max, "max is null");
        this.value = value;
        this.min = min;
        this.max = max;
    }

    @JsonProperty
    public Expression getValue() {
        return this.value;
    }

    @JsonProperty
    public Expression getMin() {
        return this.min;
    }

    @JsonProperty
    public Expression getMax() {
        return this.max;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenPredicate(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.value, (Object)this.min, (Object)this.max);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.min, this.max);
    }

    public String toString() {
        return "Between(%s, %s, %s)".formatted(this.value, this.min, this.max);
    }
}

