/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.Literal;
import java.util.Arrays;
import java.util.List;

public final class BinaryLiteral
extends Literal {
    private final byte[] value;

    @JsonCreator
    public BinaryLiteral(byte[] value) {
        this.value = (byte[])value.clone();
    }

    @JsonProperty
    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitBinaryLiteral(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryLiteral that = (BinaryLiteral)o;
        return Arrays.equals(this.value, that.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return "Binary[%s]".formatted(BaseEncoding.base16().encode(this.value));
    }
}

