/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class BindExpression
extends Expression {
    private final List<Expression> values;
    private final Expression function;

    @JsonCreator
    public BindExpression(List<Expression> values, Expression function) {
        this.values = Objects.requireNonNull(values, "values is null");
        this.function = Objects.requireNonNull(function, "function is null");
    }

    @JsonProperty
    public List<Expression> getValues() {
        return this.values;
    }

    @JsonProperty
    public Expression getFunction() {
        return this.function;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitBindExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.builder().addAll(this.values).add((Object)this.function).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BindExpression that = (BindExpression)o;
        return Objects.equals(this.values, that.values) && Objects.equals(this.function, that.function);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.function);
    }

    public String toString() {
        return "Bind(%s, %s)".formatted(this.function, this.values.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }
}

