/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public final class Cast
extends Expression {
    private final Expression expression;
    private final Type type;
    private final boolean safe;

    public Cast(Expression expression, Type type) {
        this(expression, type, false);
    }

    @JsonCreator
    public Cast(Expression expression, Type type, boolean safe) {
        Objects.requireNonNull(expression, "expression is null");
        this.expression = expression;
        this.type = type;
        this.safe = safe;
    }

    @JsonProperty
    public Expression getExpression() {
        return this.expression;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public boolean isSafe() {
        return this.safe;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitCast(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.expression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Cast cast = (Cast)o;
        return this.safe == cast.safe && this.expression.equals(cast.expression) && this.type.equals((Object)cast.type);
    }

    public int hashCode() {
        return Objects.hash(this.expression, this.type, this.safe);
    }

    public String toString() {
        return "%sCast(%s, %s)".formatted(this.safe ? "Try" : "", this.expression, this.type);
    }
}

