/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class CoalesceExpression
extends Expression {
    private final List<Expression> operands;

    public CoalesceExpression(Expression first, Expression second, Expression ... additional) {
        this((List<Expression>)ImmutableList.builder().add((Object[])new Expression[]{first, second}).add((Object[])additional).build());
    }

    @JsonCreator
    public CoalesceExpression(List<Expression> operands) {
        Objects.requireNonNull(operands, "operands is null");
        Preconditions.checkArgument((operands.size() >= 2 ? 1 : 0) != 0, (Object)"must have at least two operands");
        this.operands = ImmutableList.copyOf(operands);
    }

    @JsonProperty
    public List<Expression> getOperands() {
        return this.operands;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitCoalesceExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return this.operands;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoalesceExpression that = (CoalesceExpression)o;
        return Objects.equals(this.operands, that.operands);
    }

    public int hashCode() {
        return this.operands.hashCode();
    }

    public String toString() {
        return "Coalesce(%s)".formatted(this.operands.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }
}

