/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public final class ComparisonExpression
extends Expression {
    private final Operator operator;
    private final Expression left;
    private final Expression right;

    @JsonCreator
    public ComparisonExpression(Operator operator, Expression left, Expression right) {
        Objects.requireNonNull(operator, "operator is null");
        Objects.requireNonNull(left, "left is null");
        Objects.requireNonNull(right, "right is null");
        this.operator = operator;
        this.left = left;
        this.right = right;
    }

    @JsonProperty
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty
    public Expression getLeft() {
        return this.left;
    }

    @JsonProperty
    public Expression getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitComparisonExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.left, (Object)this.right);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparisonExpression that = (ComparisonExpression)o;
        return this.operator == that.operator && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.left, this.right});
    }

    public String toString() {
        Object[] objectArray = new Object[3];
        objectArray[0] = switch (this.operator.ordinal()) {
            case 6 -> "DistinctFrom";
            default -> this.operator.getValue();
        };
        objectArray[1] = this.left;
        objectArray[2] = this.right;
        return "%s(%s, %s)".formatted(objectArray);
    }

    public static enum Operator {
        EQUAL("="),
        NOT_EQUAL("<>"),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_THAN_OR_EQUAL(">="),
        IS_DISTINCT_FROM("IS DISTINCT FROM");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public Operator flip() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> EQUAL;
                case 1 -> NOT_EQUAL;
                case 2 -> GREATER_THAN;
                case 3 -> GREATER_THAN_OR_EQUAL;
                case 4 -> LESS_THAN;
                case 5 -> LESS_THAN_OR_EQUAL;
                case 6 -> IS_DISTINCT_FROM;
            };
        }

        public Operator negate() {
            switch (this.ordinal()) {
                case 0: {
                    return NOT_EQUAL;
                }
                case 1: {
                    return EQUAL;
                }
                case 2: {
                    return GREATER_THAN_OR_EQUAL;
                }
                case 3: {
                    return GREATER_THAN;
                }
                case 4: {
                    return LESS_THAN_OR_EQUAL;
                }
                case 5: {
                    return LESS_THAN;
                }
            }
            throw new IllegalArgumentException("Unsupported comparison: " + String.valueOf((Object)this));
        }
    }
}

