/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.Literal;
import java.util.List;
import java.util.Objects;

public final class DecimalLiteral
extends Literal {
    private final String value;

    @JsonCreator
    public DecimalLiteral(String value) {
        this.value = Objects.requireNonNull(value, "value is null");
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitDecimalLiteral(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalLiteral that = (DecimalLiteral)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return this.value;
    }
}

