/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.Literal;
import java.util.List;

public final class DoubleLiteral
extends Literal {
    private final double value;

    @JsonCreator
    public DoubleLiteral(double value) {
        this.value = value;
    }

    @JsonProperty
    public double getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitDoubleLiteral(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleLiteral that = (DoubleLiteral)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        return (int)(temp ^ temp >>> 32);
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

