/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class FunctionCall
extends Expression {
    private final QualifiedName name;
    private final List<Expression> arguments;

    @JsonCreator
    public FunctionCall(String resolvedFunction, List<Expression> arguments) {
        this(QualifiedName.of((String)"system", (String[])new String[]{"$resolved", resolvedFunction}), (List<Expression>)ImmutableList.copyOf(arguments));
    }

    public FunctionCall(QualifiedName name, List<Expression> arguments) {
        this.name = name;
        this.arguments = ImmutableList.copyOf(arguments);
    }

    @Deprecated
    public QualifiedName getName() {
        return this.name;
    }

    @JsonProperty
    public String getResolvedFunction() {
        return this.name.getSuffix();
    }

    @JsonProperty
    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionCall(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return this.arguments;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionCall o = (FunctionCall)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.arguments, o.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.arguments);
    }

    public String toString() {
        return "%s(%s)".formatted(this.name.getSuffix(), this.arguments.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }
}

