/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.Literal;
import java.util.List;
import java.util.Objects;

public final class GenericLiteral
extends Literal {
    private final Type type;
    private final String value;

    @JsonCreator
    public GenericLiteral(Type type, String value) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(value, "value is null");
        this.type = type;
        this.value = value;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitGenericLiteral(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of();
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GenericLiteral other = (GenericLiteral)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return "Literal[%s, %s]".formatted(this.type, this.value);
    }
}

