/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class IfExpression
extends Expression {
    private final Expression condition;
    private final Expression trueValue;
    private final Optional<Expression> falseValue;

    public IfExpression(Expression condition, Expression trueValue) {
        this(condition, trueValue, Optional.empty());
    }

    @JsonCreator
    public IfExpression(Expression condition, Expression trueValue, Optional<Expression> falseValue) {
        this.condition = Objects.requireNonNull(condition, "condition is null");
        this.trueValue = Objects.requireNonNull(trueValue, "trueValue is null");
        this.falseValue = Objects.requireNonNull(falseValue, "falseValue is null");
    }

    public IfExpression(Expression condition, Expression trueValue, Expression falseValue) {
        this(condition, trueValue, Optional.ofNullable(falseValue));
    }

    @JsonProperty
    public Expression getCondition() {
        return this.condition;
    }

    @JsonProperty
    public Expression getTrueValue() {
        return this.trueValue;
    }

    @JsonProperty
    public Optional<Expression> getFalseValue() {
        return this.falseValue;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitIfExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)this.condition).add((Object)this.trueValue);
        this.falseValue.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IfExpression o = (IfExpression)obj;
        return Objects.equals(this.condition, o.condition) && Objects.equals(this.trueValue, o.trueValue) && Objects.equals(this.falseValue, o.falseValue);
    }

    public int hashCode() {
        return Objects.hash(this.condition, this.trueValue, this.falseValue);
    }

    public String toString() {
        return "If(%s, %s%s)".formatted(this.condition, this.trueValue, this.falseValue.map(value -> ", " + String.valueOf(value)).orElse(""));
    }
}

