/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class InPredicate
extends Expression {
    private final Expression value;
    private final List<Expression> valueList;

    @JsonCreator
    public InPredicate(Expression value, List<Expression> valueList) {
        this.value = value;
        this.valueList = valueList;
    }

    @JsonProperty
    public Expression getValue() {
        return this.value;
    }

    @JsonProperty
    public List<Expression> getValueList() {
        return this.valueList;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitInPredicate(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.builder().add((Object)this.value).addAll(this.valueList).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InPredicate that = (InPredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.valueList, that.valueList);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.valueList);
    }

    public String toString() {
        return "In(%s, [%s])".formatted(this.value, this.valueList.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }
}

