/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.Literal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class IntervalLiteral
extends Literal {
    private final String value;
    private final Sign sign;
    private final IntervalField startField;
    private final Optional<IntervalField> endField;

    public IntervalLiteral(String value, Sign sign, IntervalField startField) {
        this(value, sign, startField, Optional.empty());
    }

    @JsonCreator
    public IntervalLiteral(String value, Sign sign, IntervalField startField, Optional<IntervalField> endField) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(sign, "sign is null");
        Objects.requireNonNull(startField, "startField is null");
        Objects.requireNonNull(endField, "endField is null");
        this.value = value;
        this.sign = sign;
        this.startField = startField;
        this.endField = endField;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public Sign getSign() {
        return this.sign;
    }

    @JsonProperty
    public IntervalField getStartField() {
        return this.startField;
    }

    @JsonProperty
    public Optional<IntervalField> getEndField() {
        return this.endField;
    }

    public boolean isYearToMonth() {
        return this.startField == IntervalField.YEAR || this.startField == IntervalField.MONTH;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitIntervalLiteral(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.sign, this.startField, this.endField});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalLiteral other = (IntervalLiteral)obj;
        return Objects.equals(this.value, other.value) && this.sign == other.sign && this.startField == other.startField && Objects.equals(this.endField, other.endField);
    }

    public String toString() {
        return "Interval[%s%s,%s%s]".formatted(new Object[]{this.startField, this.endField.map(value -> ":" + String.valueOf(value)).orElse(""), this.sign == Sign.POSITIVE ? "+" : "-", this.value});
    }

    public static enum Sign {
        POSITIVE{

            @Override
            public int multiplier() {
                return 1;
            }
        }
        ,
        NEGATIVE{

            @Override
            public int multiplier() {
                return -1;
            }
        };


        public abstract int multiplier();
    }

    public static enum IntervalField {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

