/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public final class IsNullPredicate
extends Expression {
    private final Expression value;

    @JsonCreator
    public IsNullPredicate(Expression value) {
        Objects.requireNonNull(value, "value is null");
        this.value = value;
    }

    @JsonProperty
    public Expression getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitIsNullPredicate(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsNullPredicate that = (IsNullPredicate)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "IsNull(%s)".formatted(this.value);
    }
}

