/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public final class LambdaExpression
extends Expression {
    private final List<String> arguments;
    private final Expression body;

    @JsonCreator
    public LambdaExpression(List<String> arguments, Expression body) {
        this.arguments = Objects.requireNonNull(arguments, "arguments is null");
        this.body = Objects.requireNonNull(body, "body is null");
    }

    @JsonProperty
    public List<String> getArguments() {
        return this.arguments;
    }

    @JsonProperty
    public Expression getBody() {
        return this.body;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitLambdaExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.body);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LambdaExpression that = (LambdaExpression)obj;
        return Objects.equals(this.arguments, that.arguments) && Objects.equals(this.body, that.body);
    }

    public int hashCode() {
        return Objects.hash(this.arguments, this.body);
    }

    public String toString() {
        return "(%s) -> %s".formatted(String.join((CharSequence)", ", this.arguments), this.body);
    }
}

