/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class LogicalExpression
extends Expression {
    private final Operator operator;
    private final List<Expression> terms;

    @JsonCreator
    public LogicalExpression(Operator operator, List<Expression> terms) {
        Objects.requireNonNull(operator, "operator is null");
        Preconditions.checkArgument((terms.size() >= 2 ? 1 : 0) != 0, (Object)"Expected at least 2 terms");
        this.operator = operator;
        this.terms = ImmutableList.copyOf(terms);
    }

    @JsonProperty
    public Operator getOperator() {
        return this.operator;
    }

    @JsonProperty
    public List<Expression> getTerms() {
        return this.terms;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitLogicalExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return this.terms;
    }

    public static LogicalExpression and(Expression left, Expression right) {
        return new LogicalExpression(Operator.AND, (List<Expression>)ImmutableList.of((Object)left, (Object)right));
    }

    public static LogicalExpression or(Expression left, Expression right) {
        return new LogicalExpression(Operator.OR, (List<Expression>)ImmutableList.of((Object)left, (Object)right));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogicalExpression that = (LogicalExpression)o;
        return this.operator == that.operator && Objects.equals(this.terms, that.terms);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.terms});
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = switch (this.operator.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "And";
            case 1 -> "Or";
        };
        objectArray[1] = this.terms.stream().map(Object::toString).collect(Collectors.joining(", "));
        return "%s(%s)".formatted(objectArray);
    }

    public static enum Operator {
        AND,
        OR;


        public Operator flip() {
            switch (this.ordinal()) {
                case 0: {
                    return OR;
                }
                case 1: {
                    return AND;
                }
            }
            throw new IllegalArgumentException("Unsupported logical expression type: " + String.valueOf((Object)this));
        }
    }
}

