/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;

public final class NullIfExpression
extends Expression {
    private final Expression first;
    private final Expression second;

    @JsonCreator
    public NullIfExpression(Expression first, Expression second) {
        this.first = first;
        this.second = second;
    }

    @JsonProperty
    public Expression getFirst() {
        return this.first;
    }

    @JsonProperty
    public Expression getSecond() {
        return this.second;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitNullIfExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return ImmutableList.of((Object)this.first, (Object)this.second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullIfExpression that = (NullIfExpression)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public String toString() {
        return "NullIf(%s, %s)".formatted(this.first, this.second);
    }
}

