/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Row
extends Expression {
    private final List<Expression> items;

    @JsonCreator
    public Row(List<Expression> items) {
        Objects.requireNonNull(items, "items is null");
        this.items = ImmutableList.copyOf(items);
    }

    @JsonProperty
    public List<Expression> getItems() {
        return this.items;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitRow(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        return this.items;
    }

    public int hashCode() {
        return Objects.hash(this.items);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return Objects.equals(this.items, other.items);
    }

    public String toString() {
        return "Row[%s]".formatted(this.items.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }
}

