/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SearchedCaseExpression
extends Expression {
    private final List<WhenClause> whenClauses;
    private final Optional<Expression> defaultValue;

    @JsonCreator
    public SearchedCaseExpression(List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.whenClauses = ImmutableList.copyOf(whenClauses);
        this.defaultValue = defaultValue;
    }

    @JsonProperty
    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @JsonProperty
    public Optional<Expression> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitSearchedCaseExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(this.whenClauses);
        this.defaultValue.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchedCaseExpression that = (SearchedCaseExpression)o;
        return Objects.equals(this.whenClauses, that.whenClauses) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.whenClauses, this.defaultValue);
    }

    public String toString() {
        return "SearchedCase(%s, %s)".formatted(this.whenClauses.stream().map(WhenClause::toString).collect(Collectors.joining(", ")), this.defaultValue.map(Object::toString).orElse("null"));
    }
}

