/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrVisitor;
import io.trino.sql.ir.WhenClause;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SimpleCaseExpression
extends Expression {
    private final Expression operand;
    private final List<WhenClause> whenClauses;
    private final Optional<Expression> defaultValue;

    @JsonCreator
    public SimpleCaseExpression(Expression operand, List<WhenClause> whenClauses, Optional<Expression> defaultValue) {
        Objects.requireNonNull(operand, "operand is null");
        Objects.requireNonNull(whenClauses, "whenClauses is null");
        this.operand = operand;
        this.whenClauses = ImmutableList.copyOf(whenClauses);
        this.defaultValue = defaultValue;
    }

    @JsonProperty
    public Expression getOperand() {
        return this.operand;
    }

    @JsonProperty
    public List<WhenClause> getWhenClauses() {
        return this.whenClauses;
    }

    @JsonProperty
    public Optional<Expression> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public <R, C> R accept(IrVisitor<R, C> visitor, C context) {
        return visitor.visitSimpleCaseExpression(this, context);
    }

    @Override
    public List<? extends Expression> getChildren() {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)this.operand).addAll(this.whenClauses);
        this.defaultValue.ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleCaseExpression that = (SimpleCaseExpression)o;
        return Objects.equals(this.operand, that.operand) && Objects.equals(this.whenClauses, that.whenClauses) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.operand, this.whenClauses, this.defaultValue);
    }

    public String toString() {
        return "SimpleCase(%s, %s, %s)".formatted(this.operand, this.whenClauses.stream().map(WhenClause::toString).collect(Collectors.joining(", ")), this.defaultValue.map(Object::toString).orElse("null"));
    }
}

